/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.model;

import io.takari.bpm.model.AbstractElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class ProcessDefinition
extends AbstractElement {
    private static final long serialVersionUID = 1L;
    public static final String SOURCE_TYPE_ATTRIBUTE = "sourceType";
    public static final String ATTRIBUTE_KEY_PREFIX = "__attr_";
    private String name;
    private final Map<String, AbstractElement> entities;
    private final Map<String, String> attributes;

    public ProcessDefinition(ProcessDefinition source, Map<String, String> attributes) {
        this(source.getId(), source.getChildren(), attributes);
    }

    public ProcessDefinition(String id, AbstractElement ... children) {
        this(id, Arrays.asList(children));
    }

    public ProcessDefinition(String id, Collection<AbstractElement> children) {
        this(id, children, Collections.emptyMap());
    }

    public ProcessDefinition(String id, Collection<AbstractElement> children, Map<String, String> attributes) {
        super(id);
        LinkedHashMap<String, AbstractElement> m = new LinkedHashMap<String, AbstractElement>();
        if (children != null) {
            for (AbstractElement c : children) {
                m.put(c.getId(), c);
            }
        }
        this.entities = Collections.unmodifiableMap(m);
        this.attributes = Collections.unmodifiableMap(new HashMap<String, String>(attributes));
    }

    public AbstractElement getChild(String id) {
        return this.entities.get(id);
    }

    public boolean hasChild(String id) {
        return this.entities.containsKey(id);
    }

    public Collection<AbstractElement> getChildren() {
        return this.entities.values();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }
}

