/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.model;

import java.io.Serializable;

public class VariableMapping
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String source;
    private final String sourceExpression;
    private final Object sourceValue;
    private final String target;
    private final boolean interpolateValue;

    public static VariableMapping copy(String source, String target) {
        return new VariableMapping(source, null, null, target, false);
    }

    public static VariableMapping set(Object value, String target) {
        return new VariableMapping(null, null, value, target, false);
    }

    public static VariableMapping eval(String expr, String target) {
        return new VariableMapping(null, expr, null, target, false);
    }

    public VariableMapping(String source, String sourceExpression, String target) {
        this(source, sourceExpression, null, target);
    }

    public VariableMapping(String source, String sourceExpression, Object sourceValue, String target) {
        this(source, sourceExpression, sourceValue, target, false);
    }

    public VariableMapping(String source, String sourceExpression, Object sourceValue, String target, boolean interpolateValue) {
        this.source = source;
        this.sourceExpression = sourceExpression;
        this.sourceValue = sourceValue;
        this.target = target;
        this.interpolateValue = interpolateValue;
    }

    public String getSource() {
        return this.source;
    }

    public String getSourceExpression() {
        return this.sourceExpression;
    }

    public Object getSourceValue() {
        return this.sourceValue;
    }

    public String getTarget() {
        return this.target;
    }

    public boolean isInterpolateValue() {
        return this.interpolateValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VariableMapping that = (VariableMapping)o;
        if (this.interpolateValue != that.interpolateValue) {
            return false;
        }
        if (this.source != null ? !this.source.equals(that.source) : that.source != null) {
            return false;
        }
        if (this.sourceExpression != null ? !this.sourceExpression.equals(that.sourceExpression) : that.sourceExpression != null) {
            return false;
        }
        if (this.sourceValue != null ? !this.sourceValue.equals(that.sourceValue) : that.sourceValue != null) {
            return false;
        }
        return this.target.equals(that.target);
    }

    public int hashCode() {
        int result = this.source != null ? this.source.hashCode() : 0;
        result = 31 * result + (this.sourceExpression != null ? this.sourceExpression.hashCode() : 0);
        result = 31 * result + (this.sourceValue != null ? this.sourceValue.hashCode() : 0);
        result = 31 * result + this.target.hashCode();
        result = 31 * result + (this.interpolateValue ? 1 : 0);
        return result;
    }

    public String toString() {
        return "VariableMapping [source=" + this.source + ", sourceExpression=" + this.sourceExpression + ", sourceValue=" + this.sourceValue + ", target=" + this.target + ", interpolateValue=" + this.interpolateValue + ']';
    }
}

