/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm;

import io.takari.bpm.AbstractEngine;
import io.takari.bpm.Configuration;
import io.takari.bpm.DefaultExecutor;
import io.takari.bpm.EngineListener;
import io.takari.bpm.EngineListenerHolder;
import io.takari.bpm.ExecutionInterceptorHolder;
import io.takari.bpm.Executor;
import io.takari.bpm.IndexedProcessDefinitionProvider;
import io.takari.bpm.ProcessDefinitionProvider;
import io.takari.bpm.RandomUuidGenerator;
import io.takari.bpm.UuidGenerator;
import io.takari.bpm.api.Engine;
import io.takari.bpm.api.EventService;
import io.takari.bpm.api.ExecutionContextFactory;
import io.takari.bpm.context.DefaultExecutionContextFactory;
import io.takari.bpm.context.ExecutionContextImpl;
import io.takari.bpm.el.DefaultExpressionManager;
import io.takari.bpm.el.ExpressionManager;
import io.takari.bpm.event.EventPersistenceManager;
import io.takari.bpm.event.EventPersistenceManagerImpl;
import io.takari.bpm.event.EventServiceImpl;
import io.takari.bpm.event.EventStorage;
import io.takari.bpm.event.InMemEventStorage;
import io.takari.bpm.lock.LockManager;
import io.takari.bpm.lock.StripedLockManagerImpl;
import io.takari.bpm.persistence.InMemPersistenceManager;
import io.takari.bpm.persistence.PersistenceManager;
import io.takari.bpm.planner.DefaultPlanner;
import io.takari.bpm.planner.Planner;
import io.takari.bpm.resource.ClassPathResourceResolver;
import io.takari.bpm.resource.ResourceResolver;
import io.takari.bpm.task.DefaultJavaDelegateHandler;
import io.takari.bpm.task.JavaDelegateHandler;
import io.takari.bpm.task.NoopUserTaskHandler;
import io.takari.bpm.task.ServiceTaskRegistry;
import io.takari.bpm.task.UserTaskHandler;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;

public final class EngineBuilder {
    private static final int DEFAULT_CONCURRENCY_LEVEL = 64;
    private ExecutionContextFactory<? extends ExecutionContextImpl> contextFactory;
    private EventStorage eventStorage;
    private EventPersistenceManager eventManager;
    private ExecutionInterceptorHolder interceptors;
    private EngineListenerHolder listeners;
    private Executor executor;
    private ExecutorService threadPool;
    private ExpressionManager expressionManager;
    private LockManager lockManager;
    private PersistenceManager persistenceManager;
    private Planner planner;
    private ProcessDefinitionProvider definitionProvider;
    private Function<ProcessDefinitionProvider, IndexedProcessDefinitionProvider> definitionProviderWrappingFn;
    private ServiceTaskRegistry taskRegistry;
    private UuidGenerator uuidGenerator;
    private Function<Executor, Executor> executorWrappingFn;
    private JavaDelegateHandler javaDelegateHandler;
    private UserTaskHandler userTaskHandler;
    private ResourceResolver resourceResolver;
    private Configuration configuration;

    public EngineBuilder withUuidGenerator(UuidGenerator uuidGenerator) {
        this.uuidGenerator = uuidGenerator;
        return this;
    }

    public EngineBuilder withDefinitionProvider(ProcessDefinitionProvider definitionProvider) {
        this.definitionProvider = definitionProvider;
        return this;
    }

    public EngineBuilder withEventStorage(EventStorage eventStorage) {
        this.eventStorage = eventStorage;
        return this;
    }

    public EngineBuilder withEventManager(EventPersistenceManager eventManager) {
        this.eventManager = eventManager;
        return this;
    }

    public EngineBuilder withExpressionManager(ExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
        return this;
    }

    public EngineBuilder withTaskRegistry(ServiceTaskRegistry taskRegistry) {
        this.taskRegistry = taskRegistry;
        return this;
    }

    public EngineBuilder withPersistenceManager(PersistenceManager persistenceManager) {
        this.persistenceManager = persistenceManager;
        return this;
    }

    public EngineBuilder withLockManager(LockManager lockManager) {
        this.lockManager = lockManager;
        return this;
    }

    public EngineBuilder withPlanner(Planner planner) {
        this.planner = planner;
        return this;
    }

    public EngineBuilder withExecutor(Executor executor) {
        this.executor = executor;
        return this;
    }

    public EngineBuilder withThreadPool(ExecutorService threadPool) {
        this.threadPool = threadPool;
        return this;
    }

    public EngineBuilder wrapExecutorWith(Function<Executor, Executor> fn) {
        this.executorWrappingFn = fn;
        return this;
    }

    public EngineBuilder withConfiguration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public EngineBuilder wrapDefinitionProviderWith(Function<ProcessDefinitionProvider, IndexedProcessDefinitionProvider> fn) {
        this.definitionProviderWrappingFn = fn;
        return this;
    }

    public EngineBuilder withJavaDelegateHandler(JavaDelegateHandler javaDelegateHandler) {
        this.javaDelegateHandler = javaDelegateHandler;
        return this;
    }

    public EngineBuilder withUserTaskHandler(UserTaskHandler userTaskHandler) {
        this.userTaskHandler = userTaskHandler;
        return this;
    }

    public EngineBuilder withResourceResolver(ResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
        return this;
    }

    public EngineBuilder withContextFactory(ExecutionContextFactory<? extends ExecutionContextImpl> contextFactory) {
        this.contextFactory = contextFactory;
        return this;
    }

    public EngineBuilder withListener(EngineListener listener) {
        if (this.listeners == null) {
            this.listeners = new EngineListenerHolder();
        }
        this.listeners.addListener(listener);
        return this;
    }

    public Engine build() {
        if (this.configuration == null) {
            this.configuration = new Configuration();
        }
        if (this.definitionProvider == null) {
            throw new IllegalStateException("Process definition provider is required. Use the method `builder.withDefinitionProvider(...)` to specify your own implementation.");
        }
        if (this.eventStorage == null) {
            this.eventStorage = new InMemEventStorage();
        }
        if (this.eventManager == null) {
            this.eventManager = new EventPersistenceManagerImpl(this.eventStorage);
        }
        if (this.persistenceManager == null) {
            this.persistenceManager = new InMemPersistenceManager();
        }
        if (this.taskRegistry == null) {
            throw new IllegalStateException("Service task registry is required. Use the method `builder.withTaskRegistry(...)` to specify your own implementation.");
        }
        if (this.expressionManager == null) {
            this.expressionManager = new DefaultExpressionManager(this.taskRegistry);
        }
        if (this.contextFactory == null) {
            this.contextFactory = new DefaultExecutionContextFactory(this.expressionManager);
        }
        if (this.lockManager == null) {
            this.lockManager = new StripedLockManagerImpl(64);
        }
        if (this.uuidGenerator == null) {
            this.uuidGenerator = new RandomUuidGenerator();
        }
        if (this.planner == null) {
            this.planner = new DefaultPlanner(this.configuration);
        }
        if (this.interceptors == null) {
            this.interceptors = new ExecutionInterceptorHolder();
        }
        if (this.listeners == null) {
            this.listeners = new EngineListenerHolder();
        }
        if (this.threadPool == null) {
            this.threadPool = Executors.newCachedThreadPool();
        }
        IndexedProcessDefinitionProvider indexedDefinitionProvider = this.definitionProviderWrappingFn != null ? this.definitionProviderWrappingFn.apply(this.definitionProvider) : new IndexedProcessDefinitionProvider(this.definitionProvider);
        if (this.javaDelegateHandler == null) {
            this.javaDelegateHandler = new DefaultJavaDelegateHandler();
        }
        if (this.userTaskHandler == null) {
            this.userTaskHandler = new NoopUserTaskHandler();
        }
        if (this.resourceResolver == null) {
            this.resourceResolver = new ClassPathResourceResolver();
        }
        if (this.executor == null) {
            this.executor = new DefaultExecutor(this.configuration, this.contextFactory, this.threadPool, this.interceptors, indexedDefinitionProvider, this.uuidGenerator, this.eventManager, this.persistenceManager, this.javaDelegateHandler, this.userTaskHandler, this.resourceResolver, this.taskRegistry);
        }
        if (this.executorWrappingFn != null) {
            this.executor = this.executorWrappingFn.apply(this.executor);
        }
        IndexedProcessDefinitionProvider pdp = new IndexedProcessDefinitionProvider(this.definitionProvider);
        return new EngineImpl(pdp, this.eventStorage, this.eventManager, this.persistenceManager, this.lockManager, this.uuidGenerator, this.executor, this.planner, this.configuration, this.interceptors, this.listeners);
    }

    public static final class EngineImpl
    extends AbstractEngine {
        private final IndexedProcessDefinitionProvider definitionProvider;
        private final EventPersistenceManager eventManager;
        private final PersistenceManager persistenceManager;
        private final LockManager lockManager;
        private final UuidGenerator uuidGenerator;
        private final Executor executor;
        private final Planner planner;
        private final Configuration configuration;
        private final ExecutionInterceptorHolder interceptors;
        private final EngineListenerHolder listeners;
        private final EventService eventService;

        public EngineImpl(IndexedProcessDefinitionProvider definitionProvider, EventStorage eventStorage, EventPersistenceManager eventManager, PersistenceManager persistenceManager, LockManager lockManager, UuidGenerator uuidGenerator, Executor executor, Planner planner, Configuration configuration, ExecutionInterceptorHolder interceptors, EngineListenerHolder listeners) {
            this.definitionProvider = definitionProvider;
            this.eventManager = eventManager;
            this.persistenceManager = persistenceManager;
            this.lockManager = lockManager;
            this.uuidGenerator = uuidGenerator;
            this.executor = executor;
            this.planner = planner;
            this.configuration = configuration;
            this.interceptors = interceptors;
            this.listeners = listeners;
            this.eventService = new EventServiceImpl(lockManager, eventStorage);
        }

        @Override
        public IndexedProcessDefinitionProvider getProcessDefinitionProvider() {
            return this.definitionProvider;
        }

        @Override
        public EventPersistenceManager getEventManager() {
            return this.eventManager;
        }

        @Override
        public PersistenceManager getPersistenceManager() {
            return this.persistenceManager;
        }

        @Override
        public LockManager getLockManager() {
            return this.lockManager;
        }

        @Override
        public UuidGenerator getUuidGenerator() {
            return this.uuidGenerator;
        }

        @Override
        protected ExecutionInterceptorHolder getInterceptorHolder() {
            return this.interceptors;
        }

        @Override
        protected EngineListenerHolder getListenerHolder() {
            return this.listeners;
        }

        @Override
        protected Planner getPlanner() {
            return this.planner;
        }

        @Override
        protected Executor getExecutor() {
            return this.executor;
        }

        @Override
        public Configuration getConfiguration() {
            return this.configuration;
        }

        public EventService getEventService() {
            return this.eventService;
        }
    }
}

