/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.takari.bpm.model.AbstractElement;
import io.takari.bpm.model.BoundaryEvent;
import io.takari.bpm.model.ProcessDefinition;
import io.takari.bpm.model.SequenceFlow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IndexedProcessDefinition
extends ProcessDefinition {
    private static final long serialVersionUID = 1L;
    private final Map<String, List<SequenceFlow>> outgoingFlows;
    private final Map<String, List<BoundaryEvent>> boundaryEvents;

    public IndexedProcessDefinition(ProcessDefinition pd) {
        super(pd.getId(), pd.getChildren(), pd.getAttributes() != null ? pd.getAttributes() : Collections.emptyMap());
        this.setName(pd.getName());
        this.outgoingFlows = this.indexOutgoingFlows();
        this.boundaryEvents = this.indexBoundaryEvents();
    }

    public List<SequenceFlow> findOptionalOutgoingFlows(String from) {
        return this.outgoingFlows.get(from);
    }

    public List<BoundaryEvent> findOptionalBoundaryEvents(String attachedToRef) {
        return this.boundaryEvents.get(attachedToRef);
    }

    private Map<String, List<SequenceFlow>> indexOutgoingFlows() {
        HashMap<String, List<SequenceFlow>> m = new HashMap<String, List<SequenceFlow>>();
        IndexedProcessDefinition.indexOutgoingFlows0(this, m);
        return ImmutableMap.copyOf(m);
    }

    private static void indexOutgoingFlows0(ProcessDefinition pd, Map<String, List<SequenceFlow>> accumulator) {
        for (AbstractElement e : pd.getChildren()) {
            String id = e.getId();
            List<SequenceFlow> l = IndexedProcessDefinition.findOutgoingFlows(pd, id);
            accumulator.put(id, (List<SequenceFlow>)ImmutableList.copyOf(l));
            if (!(e instanceof ProcessDefinition)) continue;
            IndexedProcessDefinition.indexOutgoingFlows0((ProcessDefinition)e, accumulator);
        }
    }

    private static List<SequenceFlow> findOutgoingFlows(ProcessDefinition pd, String from) {
        ArrayList<SequenceFlow> result = new ArrayList<SequenceFlow>();
        for (AbstractElement e : pd.getChildren()) {
            SequenceFlow f;
            if (!(e instanceof SequenceFlow) || !from.equals((f = (SequenceFlow)e).getFrom())) continue;
            result.add(f);
        }
        return result;
    }

    private Map<String, List<BoundaryEvent>> indexBoundaryEvents() {
        HashMap<String, List<BoundaryEvent>> m = new HashMap<String, List<BoundaryEvent>>();
        IndexedProcessDefinition.indexBoundaryEvents0(this, m);
        return m;
    }

    private static void indexBoundaryEvents0(ProcessDefinition pd, Map<String, List<BoundaryEvent>> accumulator) {
        for (AbstractElement e : pd.getChildren()) {
            BoundaryEvent ev;
            if (e instanceof ProcessDefinition) {
                IndexedProcessDefinition.indexBoundaryEvents0((ProcessDefinition)e, accumulator);
            }
            if (!(e instanceof BoundaryEvent) || (ev = (BoundaryEvent)e).getAttachedToRef() == null) continue;
            List l = accumulator.computeIfAbsent(ev.getAttachedToRef(), k -> new ArrayList());
            l.add(ev);
        }
    }
}

