/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.el;

import io.takari.bpm.api.ExecutionContext;
import io.takari.bpm.api.ExecutionContextFactory;
import io.takari.bpm.el.ExpressionManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Interpolator {
    private Interpolator() {
    }

    public static Object interpolate(ExecutionContextFactory<?> f, ExpressionManager em, ExecutionContext ctx, Object v) {
        return Interpolator.interpolate(new ExecutionContextEvaluator(f, em), ctx, v);
    }

    public static <T> Object interpolate(Evaluator<T> evaluator, T ctx, Object v) {
        if (v instanceof String) {
            String s = (String)v;
            if (!evaluator.hasExpression(s)) {
                return s;
            }
            return evaluator.eval(ctx, s);
        }
        if (v instanceof Map) {
            return Interpolator.interpolateMap(evaluator, ctx, (Map)v);
        }
        if (v instanceof List) {
            List src = (List)v;
            if (src.isEmpty()) {
                return v;
            }
            ArrayList<Object> dst = new ArrayList<Object>(src.size());
            for (Object vv : src) {
                dst.add(Interpolator.interpolate(evaluator, ctx, vv));
            }
            return dst;
        }
        if (v instanceof Set) {
            Set src = (Set)v;
            if (src.isEmpty()) {
                return v;
            }
            HashSet<Object> dst = new HashSet<Object>(src.size());
            for (Object vv : src) {
                dst.add(Interpolator.interpolate(evaluator, ctx, vv));
            }
            return dst;
        }
        if (v instanceof Object[]) {
            Object[] src = (Object[])v;
            if (src.length == 0) {
                return v;
            }
            int i = 0;
            while (i < src.length) {
                src[i] = Interpolator.interpolate(evaluator, ctx, src[i]);
                ++i;
            }
        }
        return v;
    }

    private static <T> Map<?, ?> interpolateMap(Evaluator<T> evaluator, T ctx, Map<?, ?> m) {
        if (m.isEmpty()) {
            return m;
        }
        LinkedHashMap<Object, Object> mm = new LinkedHashMap<Object, Object>(m.size());
        ctx = evaluator.withOverrides(ctx, mm);
        for (Map.Entry<?, ?> e : m.entrySet()) {
            Object k = e.getKey();
            mm.put(k, Interpolator._interpolate(evaluator, ctx, mm, k, e.getValue(), mm));
        }
        return mm;
    }

    /*
     * WARNING - void declaration
     */
    private static <T> Object _interpolate(Evaluator<T> evaluator, T ctx, Map<Object, Object> container, Object k, Object v, Map<Object, Object> overrides) {
        Object dst;
        Object src;
        if (v instanceof String) {
            String s = (String)v;
            if (evaluator.hasExpression(s)) {
                v = evaluator.eval(ctx, s);
            }
        } else if (v instanceof Map) {
            Map m = (Map)v;
            if (!m.isEmpty()) {
                LinkedHashMap<Object, Object> mm = new LinkedHashMap<Object, Object>(m);
                if (container != null) {
                    container.put(k, mm);
                }
                for (Map.Entry entry : m.entrySet()) {
                    Object kk = entry.getKey();
                    Object interpolatedValue = Interpolator._interpolate(evaluator, ctx, mm, kk, entry.getValue(), overrides);
                    if (Interpolator.contains(mm, interpolatedValue)) {
                        HashMap<Object, Object> oldOverrides = new HashMap<Object, Object>(overrides);
                        overrides.clear();
                        interpolatedValue = Interpolator._interpolate(evaluator, ctx, mm, kk, entry.getValue(), overrides);
                        overrides.putAll(oldOverrides);
                    }
                    mm.put(kk, interpolatedValue);
                }
                v = mm;
            }
        } else if (v instanceof List) {
            src = (List)v;
            if (!src.isEmpty()) {
                dst = new ArrayList(src.size());
                for (Map.Entry entry : src) {
                    dst.add(Interpolator._interpolate(evaluator, ctx, null, null, entry, overrides));
                }
                v = dst;
            }
        } else if (v instanceof Set && !(src = (Set)v).isEmpty()) {
            dst = new HashSet(src.size());
            for (Map.Entry entry : src) {
                dst.add(Interpolator._interpolate(evaluator, ctx, null, null, entry, overrides));
            }
            v = dst;
        }
        if (v instanceof Object[] && ((Object[])(src = (Object[])v)).length != 0) {
            void var8_14;
            dst = new Object[((Object[])src).length];
            boolean bl = false;
            while (var8_14 < ((Object[])src).length) {
                dst[var8_14] = Interpolator._interpolate(evaluator, ctx, null, null, src[var8_14], overrides);
                ++var8_14;
            }
            v = dst;
        }
        return v;
    }

    private static boolean contains(Object o, Object interpolatedValue) {
        block6: {
            block7: {
                block5: {
                    if (o == interpolatedValue) {
                        return true;
                    }
                    if (!(interpolatedValue instanceof Map)) break block5;
                    for (Map.Entry e : ((Map)interpolatedValue).entrySet()) {
                        if (!Interpolator.contains(o, e.getValue())) continue;
                        return true;
                    }
                    break block6;
                }
                if (!(interpolatedValue instanceof Collection)) break block7;
                for (Object e : (Collection)interpolatedValue) {
                    if (!Interpolator.contains(o, e)) continue;
                    return true;
                }
                break block6;
            }
            if (!(interpolatedValue instanceof Object[])) break block6;
            Object[] objectArray = (Object[])interpolatedValue;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object e = objectArray[n2];
                if (Interpolator.contains(o, e)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static interface Evaluator<T> {
        public boolean hasExpression(String var1);

        public Object eval(T var1, String var2);

        public T withOverrides(T var1, Map<Object, Object> var2);
    }

    private static class ExecutionContextEvaluator
    implements Evaluator<ExecutionContext> {
        private final ExecutionContextFactory<? extends ExecutionContext> ctxFactory;
        private final ExpressionManager expressionManager;

        private ExecutionContextEvaluator(ExecutionContextFactory<? extends ExecutionContext> ctxFactory, ExpressionManager expressionManager) {
            this.ctxFactory = ctxFactory;
            this.expressionManager = expressionManager;
        }

        @Override
        public boolean hasExpression(String v) {
            return v.contains("${");
        }

        @Override
        public Object eval(ExecutionContext ctx, String v) {
            return this.expressionManager.eval(ctx, v, Object.class);
        }

        @Override
        public ExecutionContext withOverrides(ExecutionContext ctx, Map<Object, Object> overrides) {
            return this.ctxFactory.withOverrides(ctx, overrides);
        }
    }
}

