/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.elements;

import io.takari.bpm.IndexedProcessDefinition;
import io.takari.bpm.ProcessDefinitionUtils;
import io.takari.bpm.actions.Action;
import io.takari.bpm.actions.EvalExpressionAction;
import io.takari.bpm.actions.FollowFlowsAction;
import io.takari.bpm.actions.PopCommandAction;
import io.takari.bpm.api.ExecutionException;
import io.takari.bpm.commands.Command;
import io.takari.bpm.commands.ProcessElementCommand;
import io.takari.bpm.elements.ElementHandler;
import io.takari.bpm.model.ExpressionType;
import io.takari.bpm.model.SequenceFlow;
import io.takari.bpm.model.ServiceTask;
import io.takari.bpm.model.VariableMapping;
import io.takari.bpm.state.ProcessInstance;
import io.takari.bpm.utils.Timeout;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceTaskHandler
implements ElementHandler {
    private static final Logger log = LoggerFactory.getLogger(ServiceTaskHandler.class);

    @Override
    public List<Action> handle(ProcessInstance state, ProcessElementCommand cmd, List<Action> actions) throws ExecutionException {
        actions.add(new PopCommandAction());
        IndexedProcessDefinition pd = state.getDefinition(cmd.getDefinitionId());
        ServiceTask t = (ServiceTask)ProcessDefinitionUtils.findElement(pd, cmd.getElementId());
        ExpressionType type = t.getType();
        String expr = t.getExpression();
        if (expr != null && type != ExpressionType.NONE) {
            SequenceFlow nextFlow = ProcessDefinitionUtils.findOutgoingFlow(pd, cmd.getElementId());
            ProcessElementCommand defaultCommand = new ProcessElementCommand(pd.getId(), nextFlow.getId());
            List<Timeout<Command>> timeouts = ProcessDefinitionUtils.findTimers(pd, cmd);
            Command defaultError = ProcessDefinitionUtils.findDefaultError(pd, cmd);
            Map<String, Command> errors = ProcessDefinitionUtils.findErrors(pd, cmd);
            actions.add(new EvalExpressionAction.Builder(cmd.getDefinitionId(), t.getId(), t.getType(), t.getExpression(), defaultCommand).withTimeouts(timeouts).withDefaultError(defaultError).withErrors(errors).withInVariables(ServiceTaskHandler.notEmpty(t.getIn())).withOutVariables(ServiceTaskHandler.notEmpty(t.getOut())).withCopyAllVariables(t.isCopyAllVariables()).build());
            log.debug("handle ['{}', '{}', {}, '{}'] -> done", new Object[]{state.getBusinessKey(), cmd.getElementId(), type, expr});
        } else {
            log.debug("handle ['{}', '{}', {}, '{}'] -> noop", new Object[]{state.getBusinessKey(), cmd.getElementId(), type, expr});
            actions.add(new FollowFlowsAction(cmd.getDefinitionId(), cmd.getElementId()));
        }
        return actions;
    }

    private static Set<VariableMapping> notEmpty(Set<VariableMapping> s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        return s;
    }
}

