/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.event;

import io.takari.bpm.api.ExecutionException;
import io.takari.bpm.event.Event;
import io.takari.bpm.event.EventPersistenceManager;
import io.takari.bpm.event.EventStorage;
import io.takari.bpm.event.ExpiredEvent;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventPersistenceManagerImpl
implements EventPersistenceManager {
    private static final Logger log = LoggerFactory.getLogger(EventPersistenceManagerImpl.class);
    private final EventStorage eventStorage;

    public EventPersistenceManagerImpl(EventStorage eventStorage) {
        this.eventStorage = eventStorage;
    }

    @Override
    public Event get(UUID id) {
        Event result = this.eventStorage.get(id);
        log.debug("get ['{}'] -> done ({})", (Object)id, (Object)(result != null ? 1 : 0));
        return result;
    }

    @Override
    public Event remove(UUID id) {
        Event result = this.eventStorage.remove(id);
        log.debug("remove ['{}'] -> done ({})", (Object)id, (Object)(result != null ? 1 : 0));
        return result;
    }

    @Override
    public Collection<Event> find(String processBusinessKey, String eventName) {
        Collection<Event> result = this.eventStorage.find(processBusinessKey, eventName);
        log.debug("find ['{}', '{}'] -> done ({})", new Object[]{processBusinessKey, eventName, result.size()});
        return result;
    }

    @Override
    public void add(Event event) throws ExecutionException {
        this.eventStorage.add(event);
        log.debug("add ['{}'] -> done", (Object)event);
    }

    @Override
    public void clearGroup(String processBusinessKey, UUID groupId) {
        int removed = 0;
        Collection<Event> evs = this.eventStorage.find(processBusinessKey);
        for (Event e : evs) {
            UUID otherGid = e.getScopeId();
            if (!groupId.equals(otherGid)) continue;
            this.eventStorage.remove(e.getId());
            ++removed;
        }
        log.debug("clearGroup ['{}', '{}'] -> total: {}, removed: {}", new Object[]{processBusinessKey, groupId, evs.size(), removed});
    }

    @Override
    public List<ExpiredEvent> findNextExpiredEvent(int maxEvents) throws ExecutionException {
        List<ExpiredEvent> result = this.eventStorage.findNextExpiredEvent(maxEvents);
        log.debug("findNextExpiredEvent [{}] -> done ({})", (Object)maxEvents, (Object)result.size());
        return result;
    }
}

