/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.event;

import io.takari.bpm.event.Event;
import io.takari.bpm.event.EventStorage;
import io.takari.bpm.event.ExpiredEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class InMemEventStorage
implements EventStorage {
    private final Map<UUID, Event> events = new HashMap<UUID, Event>();
    private final List<ExpiredEvent> eventsToExecute = new ArrayList<ExpiredEvent>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Event get(UUID k) {
        Map<UUID, Event> map = this.events;
        synchronized (map) {
            return this.events.get(k);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Event remove(UUID k) {
        Map<UUID, Event> map = this.events;
        synchronized (map) {
            Event e = this.events.remove(k);
            this.removeEventExpiredEvent(e);
            return e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Event> find(String processBusinessKey, String eventName) {
        Map<UUID, Event> map = this.events;
        synchronized (map) {
            ArrayList<Event> c = new ArrayList<Event>();
            for (Event e : this.events.values()) {
                if (!e.getProcessBusinessKey().equals(processBusinessKey) || !e.getName().equals(eventName)) continue;
                c.add(e);
            }
            return c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Event> find(String processBusinessKey) {
        Map<UUID, Event> map = this.events;
        synchronized (map) {
            ArrayList<Event> c = new ArrayList<Event>();
            for (Event e : this.events.values()) {
                if (!e.getProcessBusinessKey().equals(processBusinessKey)) continue;
                c.add(e);
            }
            return c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Event event) {
        Map<UUID, Event> map = this.events;
        synchronized (map) {
            this.events.put(event.getId(), event);
            if (event.getExpiredAt() != null) {
                this.eventsToExecute.add(new ExpiredEvent(event.getId(), event.getExpiredAt()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ExpiredEvent> findNextExpiredEvent(int maxEvents) {
        ArrayList<ExpiredEvent> result = new ArrayList<ExpiredEvent>(maxEvents);
        Map<UUID, Event> map = this.events;
        synchronized (map) {
            Date now = new Date();
            Iterator<ExpiredEvent> it = this.eventsToExecute.iterator();
            while (it.hasNext()) {
                ExpiredEvent e = it.next();
                Date expiredAt = e.getExpiredAt();
                if (now.after(expiredAt) || now.equals(expiredAt)) {
                    result.add(e);
                    it.remove();
                }
                if (result.size() >= maxEvents) break;
            }
        }
        return result;
    }

    private void removeEventExpiredEvent(Event e) {
        if (e == null) {
            return;
        }
        this.eventsToExecute.removeIf(ee -> ee.geId().equals(e.getId()));
    }
}

