/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.form;

import io.takari.bpm.IndexedProcessDefinition;
import io.takari.bpm.ProcessDefinitionUtils;
import io.takari.bpm.actions.CreateEventAction;
import io.takari.bpm.api.ExecutionContext;
import io.takari.bpm.api.ExecutionContextFactory;
import io.takari.bpm.api.ExecutionException;
import io.takari.bpm.api.Variables;
import io.takari.bpm.form.FormDefinitionProvider;
import io.takari.bpm.form.FormService;
import io.takari.bpm.model.UserTask;
import io.takari.bpm.model.form.FormDefinition;
import io.takari.bpm.model.form.FormExtension;
import io.takari.bpm.model.form.FormField;
import io.takari.bpm.state.ProcessInstance;
import io.takari.bpm.state.StateHelper;
import io.takari.bpm.task.UserTaskHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormTaskHandler
implements UserTaskHandler {
    private static final Logger log = LoggerFactory.getLogger(FormTaskHandler.class);
    private final ExecutionContextFactory contextFactory;
    private final FormDefinitionProvider formDefinitionProvider;
    private final FormService formService;

    public FormTaskHandler(ExecutionContextFactory contextFactory, FormDefinitionProvider formDefinitionProvider, FormService formService) {
        this.contextFactory = contextFactory;
        this.formDefinitionProvider = formDefinitionProvider;
        this.formService = formService;
    }

    @Override
    public ProcessInstance handle(ProcessInstance state, String definitionId, String elementId) throws ExecutionException {
        IndexedProcessDefinition pd = state.getDefinition(definitionId);
        UserTask task = (UserTask)ProcessDefinitionUtils.findElement(pd, elementId);
        FormExtension x = FormTaskHandler.findFormExtension(task.getExtensions());
        if (x == null) {
            return state;
        }
        log.debug("handle ['{}', '{}', '{}'] -> found form extension: {}", new Object[]{state.getBusinessKey(), definitionId, elementId, x});
        Map<String, Object> options = this.getOptions(x, state.getVariables());
        String formId = this.resolveFormId(x, state.getVariables());
        FormDefinition fd = this.getOrCreateFormDefinition(formId, options);
        if (fd == null) {
            throw new ExecutionException("Form definition not found: " + formId);
        }
        String pk = state.getBusinessKey();
        UUID fId = UUID.randomUUID();
        String eventName = UUID.randomUUID().toString();
        Map env = state.getVariables().asMap();
        this.formService.create(pk, fId, eventName, fd, options, env);
        return StateHelper.push(state, new CreateEventAction(definitionId, elementId, eventName, null, null, null, null, false));
    }

    private Map<String, Object> getOptions(FormExtension x, Variables vars) {
        ExecutionContext ctx = this.contextFactory.create(vars);
        return (Map)ctx.interpolate((Object)x.getOptions());
    }

    private String resolveFormId(FormExtension x, Variables vars) {
        if (x.getFormIdExpression() == null) {
            return x.getFormId();
        }
        ExecutionContext ctx = this.contextFactory.create(vars);
        return (String)ctx.interpolate((Object)x.getFormIdExpression());
    }

    private FormDefinition getOrCreateFormDefinition(String formId, Map<String, Object> options) throws ExecutionException {
        Object v;
        Object object = v = options != null ? options.get("fields") : null;
        if (v == null) {
            return this.formDefinitionProvider.getById(formId);
        }
        if (!(v instanceof List)) {
            throw new IllegalArgumentException("Expected a list of fields in form '" + formId + "', got: " + v.getClass());
        }
        return new FormDefinition(formId, this.coerceToFormFields((List)v));
    }

    private List<FormField> coerceToFormFields(List<?> input) {
        ArrayList<FormField> result = new ArrayList<FormField>(input.size());
        for (Object v : input) {
            if (v instanceof FormField) {
                result.add((FormField)v);
                continue;
            }
            if (v instanceof Map) {
                FormField f = this.formService.toFormField((Map)v);
                result.add(f);
                continue;
            }
            throw new IllegalArgumentException("Expected either a FormField instance or a map of values, got: " + v);
        }
        return result;
    }

    private static FormExtension findFormExtension(Collection<UserTask.Extension> extensions) {
        if (extensions == null || extensions.isEmpty()) {
            return null;
        }
        for (UserTask.Extension e : extensions) {
            if (!(e instanceof FormExtension)) continue;
            return (FormExtension)e;
        }
        return null;
    }
}

