/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.lock;

import com.google.common.util.concurrent.Striped;
import io.takari.bpm.lock.LockManager;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StripedLockManagerImpl
implements LockManager {
    private static final Logger log = LoggerFactory.getLogger(StripedLockManagerImpl.class);
    private final Striped<Lock> locks;

    public StripedLockManagerImpl(int concurrencyLevel) {
        this.locks = Striped.lock((int)concurrencyLevel);
    }

    @Override
    public void lock(String processBusinessKey) {
        log.debug("lock ['{}'] -> locking...", (Object)processBusinessKey);
        ((Lock)this.locks.get((Object)processBusinessKey)).lock();
        log.debug("lock ['{}'] -> locked", (Object)processBusinessKey);
    }

    @Override
    public void unlock(String processBusinessKey) {
        ((Lock)this.locks.get((Object)processBusinessKey)).unlock();
        log.debug("lock ['{}'] -> unlocked", (Object)processBusinessKey);
    }
}

