/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.persistence;

import io.takari.bpm.api.ExecutionException;
import io.takari.bpm.persistence.PersistenceManager;
import io.takari.bpm.state.ProcessInstance;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemPersistenceManager
implements PersistenceManager {
    private static final Logger log = LoggerFactory.getLogger(InMemPersistenceManager.class);
    private final Map<UUID, ProcessInstance> data = new ConcurrentHashMap<UUID, ProcessInstance>();

    @Override
    public void save(ProcessInstance state) throws ExecutionException {
        this.data.put(state.getId(), state);
        log.debug("save ['{}'] -> done", (Object)state.getId());
    }

    @Override
    public ProcessInstance get(UUID id) {
        ProcessInstance i = this.data.get(id);
        if (i == null) {
            log.warn("get ['{}'] -> not found", (Object)id);
        } else {
            log.debug("get ['{}'] -> found", (Object)id);
        }
        return i;
    }

    @Override
    public void remove(UUID id) {
        this.data.remove(id);
        log.debug("remove ['{}'] -> done", (Object)id);
    }
}

