/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.reducers;

import io.takari.bpm.Configuration;
import io.takari.bpm.actions.SetVariableAction;
import io.takari.bpm.api.BpmnError;
import io.takari.bpm.api.ExecutionException;
import io.takari.bpm.commands.Command;
import io.takari.bpm.commands.CommandStack;
import io.takari.bpm.commands.PerformActionsCommand;
import io.takari.bpm.reducers.Reducer;
import io.takari.bpm.state.BpmnErrorHelper;
import io.takari.bpm.state.ProcessInstance;
import java.util.Map;

public abstract class BpmnErrorHandlingReducer
implements Reducer {
    private final Configuration cfg;

    protected BpmnErrorHandlingReducer(Configuration cfg) {
        this.cfg = cfg;
    }

    protected ProcessInstance handleException(ProcessInstance state, String definitionId, String elementId, Exception e, Map<String, Command> routes, Command defaultCmd) throws ExecutionException {
        Throwable cause = e;
        while ((cause = cause.getCause()) != null && !(cause instanceof BpmnError)) {
        }
        if (cause == null) {
            if (this.cfg.isWrapAllExceptionsAsBpmnErrors()) {
                cause = new BpmnError(null, (Throwable)e);
            } else {
                throw new ExecutionException("Unhandled execution exception: " + elementId, (Throwable)e);
            }
        }
        return this.handleBpmnError(state, definitionId, elementId, (BpmnError)cause, routes, defaultCmd);
    }

    protected ProcessInstance handleBpmnError(ProcessInstance state, String definitionId, String elementId, BpmnError e, Map<String, Command> routes, Command defaultCmd) throws ExecutionException {
        String errorRef;
        Command nextCmd = null;
        if (e.getDefinitionId() == null) {
            e = new BpmnError(definitionId, elementId, e.getErrorRef(), e.getCause());
        }
        if ((errorRef = e.getErrorRef()) != null && routes != null) {
            nextCmd = routes.get(errorRef);
        }
        if (nextCmd == null) {
            nextCmd = defaultCmd;
        }
        if (nextCmd == null) {
            CommandStack stack = state.getStack().push(new PerformActionsCommand(BpmnErrorHelper.raiseError(definitionId, elementId, errorRef, e.getCause())));
            state = state.setStack(stack);
        } else {
            CommandStack stack = state.getStack().push(nextCmd).push(new PerformActionsCommand(new SetVariableAction("lastError", e)));
            state = state.setStack(stack);
        }
        return state;
    }
}

