/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.reducers;

import com.google.common.collect.Lists;
import io.takari.bpm.IndexedProcessDefinition;
import io.takari.bpm.ProcessDefinitionUtils;
import io.takari.bpm.UuidGenerator;
import io.takari.bpm.actions.Action;
import io.takari.bpm.actions.CreateEventAction;
import io.takari.bpm.actions.PopScopeAction;
import io.takari.bpm.actions.SetCurrentScopeAction;
import io.takari.bpm.api.ExecutionContext;
import io.takari.bpm.api.ExecutionContextFactory;
import io.takari.bpm.api.ExecutionException;
import io.takari.bpm.commands.Command;
import io.takari.bpm.commands.PerformActionsCommand;
import io.takari.bpm.commands.ProcessElementCommand;
import io.takari.bpm.event.Event;
import io.takari.bpm.event.EventPersistenceManager;
import io.takari.bpm.model.SequenceFlow;
import io.takari.bpm.reducers.Impure;
import io.takari.bpm.reducers.Reducer;
import io.takari.bpm.state.Events;
import io.takari.bpm.state.ProcessInstance;
import io.takari.bpm.state.Scopes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;

@Impure
public class EventsReducer
implements Reducer {
    private final ExecutionContextFactory<?> contextFactory;
    private final UuidGenerator uuidGenerator;
    private final EventPersistenceManager eventManager;

    public EventsReducer(ExecutionContextFactory<?> contextFactory, UuidGenerator uuidGenerator, EventPersistenceManager eventManager) {
        this.contextFactory = contextFactory;
        this.uuidGenerator = uuidGenerator;
        this.eventManager = eventManager;
    }

    @Override
    public ProcessInstance reduce(ProcessInstance state, Action action) throws ExecutionException {
        if (!(action instanceof CreateEventAction)) {
            return state;
        }
        CreateEventAction a = (CreateEventAction)action;
        IndexedProcessDefinition pd = state.getDefinition(a.getDefinitionId());
        SequenceFlow next = ProcessDefinitionUtils.findOutgoingFlow(pd, a.getElementId());
        Scopes.Scope scope = state.getScopes().peek();
        List<Scopes.Scope> scopes = state.getScopes().traverse(scope.getId());
        ArrayList<Command> cmds = new ArrayList<Command>();
        EventsReducer.addScopeClosingActions(cmds, scopes);
        if (a.isResumeFromSameStep()) {
            cmds.add(new ProcessElementCommand(pd.getId(), a.getElementId()));
        } else {
            cmds.add(new ProcessElementCommand(pd.getId(), next.getId()));
        }
        cmds.add(new PerformActionsCommand(new SetCurrentScopeAction(scope.getId())));
        Events events = state.getEvents();
        Event ev = this.makeEvent(state, a);
        state = state.setEvents(events.addEvent(ev.getScopeId(), ev.getId(), ev.getName(), cmds.toArray(new Command[0])));
        this.eventManager.add(ev);
        return state;
    }

    private Event makeEvent(ProcessInstance state, CreateEventAction action) throws ExecutionException {
        ExecutionContext ctx = this.contextFactory.create(state.getVariables(), action.getDefinitionId(), action.getElementId());
        UUID id = this.uuidGenerator.generate();
        String name = EventsReducer.getEventName(action, ctx);
        Date timeDate = EventsReducer.parseTimeDate(ctx, action);
        Date timeDuration = EventsReducer.parseExpiredAt(this.contextFactory, state, action);
        Date expiredAt = timeDate != null ? timeDate : timeDuration;
        Scopes.Scope s = state.getScopes().peek();
        UUID scopeId = s.getId();
        boolean exclusive = s.isExclusive();
        return new Event(id, state.getId(), action.getDefinitionId(), scopeId, name, state.getBusinessKey(), exclusive, expiredAt, action.getPayload());
    }

    private static void addScopeClosingActions(Collection<Command> cmds, List<Scopes.Scope> currentStack) {
        for (Scopes.Scope s : Lists.reverse(currentStack)) {
            if (s.getFinishers() == null) {
                cmds.add(new PerformActionsCommand(new PopScopeAction()));
                continue;
            }
            Collections.addAll(cmds, s.getFinishers());
        }
    }

    private static String getEventName(CreateEventAction a, ExecutionContext ctx) {
        String msgRefExpr = a.getMessageRefExpression();
        if (msgRefExpr != null) {
            return (String)ctx.eval(msgRefExpr, String.class);
        }
        String msgRef = a.getMessageRef();
        return msgRef != null ? msgRef : a.getElementId();
    }

    private static Date parseTimeDate(ExecutionContext ctx, CreateEventAction a) throws ExecutionException {
        String definitionId = a.getDefinitionId();
        String elementId = a.getElementId();
        String s = a.getTimeDate();
        Object v = EventsReducer.eval(s, ctx, Object.class);
        if (v == null) {
            return null;
        }
        if (v instanceof String) {
            return EventsReducer.parseIso8601(s);
        }
        if (v instanceof Date) {
            return (Date)v;
        }
        throw new ExecutionException("Invalid timeDate format in the process '%s' in the element '%s': '%s'", new Object[]{definitionId, elementId, s});
    }

    private static Date parseExpiredAt(ExecutionContextFactory<?> contextFactory, ProcessInstance state, CreateEventAction a) throws ExecutionException {
        ExecutionContext ctx;
        String definitionId = a.getDefinitionId();
        String elementId = a.getElementId();
        String s = a.getTimeDuration();
        Object v = EventsReducer.eval(s, ctx = contextFactory.create(state.getVariables(), a.getDefinitionId(), a.getElementId()), Object.class);
        if (v == null) {
            return null;
        }
        if (v instanceof String && EventsReducer.isDuration(v.toString())) {
            return DateTime.now().plus((ReadablePeriod)Period.parse((String)v.toString())).toDate();
        }
        throw new ExecutionException("Invalid duration format in the process '%s' in the element '%s': '%s'", new Object[]{definitionId, elementId, s});
    }

    private static <T> T eval(String expr, ExecutionContext ctx, Class<T> type) {
        if (expr == null || expr.trim().isEmpty()) {
            return null;
        }
        return (T)ctx.eval(expr, type);
    }

    public static Date parseIso8601(String s) {
        return DateTime.parse((String)s).toDate();
    }

    private static boolean isDuration(String time) {
        return time.startsWith("P");
    }
}

