/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.reducers;

import io.takari.bpm.IndexedProcessDefinition;
import io.takari.bpm.ProcessDefinitionUtils;
import io.takari.bpm.actions.Action;
import io.takari.bpm.actions.ProcessFlowListenersAction;
import io.takari.bpm.api.ExecutionContext;
import io.takari.bpm.api.ExecutionContextFactory;
import io.takari.bpm.api.ExecutionException;
import io.takari.bpm.api.ExecutionListener;
import io.takari.bpm.model.ExpressionType;
import io.takari.bpm.model.SequenceFlow;
import io.takari.bpm.reducers.Impure;
import io.takari.bpm.reducers.Reducer;
import io.takari.bpm.state.ProcessInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Impure
public class FlowListenerReducer
implements Reducer {
    private static final Logger log = LoggerFactory.getLogger(FlowListenerReducer.class);
    private final ExecutionContextFactory<?> contextFactory;

    public FlowListenerReducer(ExecutionContextFactory<?> contextFactory) {
        this.contextFactory = contextFactory;
    }

    @Override
    public ProcessInstance reduce(ProcessInstance state, Action action) throws ExecutionException {
        if (!(action instanceof ProcessFlowListenersAction)) {
            return state;
        }
        ProcessFlowListenersAction a = (ProcessFlowListenersAction)action;
        IndexedProcessDefinition pd = state.getDefinition(a.getDefinitionId());
        SequenceFlow f = (SequenceFlow)ProcessDefinitionUtils.findElement(pd, a.getElementId());
        ExecutionContext ctx = this.contextFactory.create(state.getVariables(), a.getDefinitionId(), a.getElementId());
        FlowListenerReducer.processListeners(ctx, f);
        return state;
    }

    private static void processListeners(ExecutionContext ctx, SequenceFlow f) throws ExecutionException {
        if (f.getListeners() == null) {
            return;
        }
        SequenceFlow.ExecutionListener[] executionListenerArray = f.getListeners();
        int n = executionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SequenceFlow.ExecutionListener l = executionListenerArray[n2];
            ExpressionType type = l.getType();
            String expr = l.getExpression();
            if (expr != null) {
                try {
                    switch (type) {
                        case SIMPLE: {
                            ctx.eval(expr, Object.class);
                            break;
                        }
                        case DELEGATE: {
                            ExecutionListener d = (ExecutionListener)ctx.eval(expr, ExecutionListener.class);
                            d.notify(ctx);
                        }
                    }
                }
                catch (Exception e) {
                    log.error("processListeners ['{}'] -> error", (Object)f.getId(), (Object)e);
                    throw new ExecutionException("Unhandled listener exception: " + e.getMessage(), (Throwable)e);
                }
            }
            ++n2;
        }
    }
}

