/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.state;

import java.io.Serializable;
import java.util.Set;
import java.util.UUID;
import org.pcollections.HashTreePMap;
import org.pcollections.OrderedPSet;
import org.pcollections.PMap;
import org.pcollections.POrderedSet;

public class Forks
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final PMap<ForkKey, Fork> values;

    public Forks() {
        this((PMap<ForkKey, Fork>)HashTreePMap.empty());
    }

    private Forks(PMap<ForkKey, Fork> values) {
        this.values = values;
    }

    public boolean containsFork(UUID scopeId, String elementId) {
        return this.values.containsKey((Object)new ForkKey(scopeId, elementId));
    }

    public Fork getFork(UUID scopeId, String elementId) {
        return (Fork)this.values.get((Object)new ForkKey(scopeId, elementId));
    }

    public Forks removeFork(UUID scopeId, String elementId) {
        return new Forks((PMap<ForkKey, Fork>)this.values.minus((Object)new ForkKey(scopeId, elementId)));
    }

    public Forks incrementFlow(UUID scopeId, String elementId, String flowId, int diff) {
        ForkKey k = new ForkKey(scopeId, elementId);
        Fork f = (Fork)this.values.get((Object)k);
        if (f == null) {
            f = new Fork();
        }
        return new Forks((PMap<ForkKey, Fork>)this.values.plus((Object)k, (Object)f.increment(flowId, diff)));
    }

    public static class Fork
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final POrderedSet<String> flows;
        private final PMap<String, Integer> flowCounts;

        public Fork() {
            this((POrderedSet<String>)OrderedPSet.empty(), (PMap<String, Integer>)HashTreePMap.empty());
        }

        public Set<String> getFlows() {
            return this.flows;
        }

        public int getFlowCount(String flowId) {
            return (Integer)this.flowCounts.get((Object)flowId);
        }

        private Fork(POrderedSet<String> flows, PMap<String, Integer> flowCounts) {
            this.flows = flows;
            this.flowCounts = flowCounts;
        }

        public Fork increment(String flowId, int diff) {
            Integer cobj = (Integer)this.flowCounts.get((Object)flowId);
            int c = cobj == null ? 0 : cobj;
            return new Fork((POrderedSet<String>)this.flows.plus((Object)flowId), (PMap<String, Integer>)this.flowCounts.plus((Object)flowId, (Object)(c + diff)));
        }
    }

    public static final class ForkKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final UUID scopeId;
        private final String elementId;

        public ForkKey(UUID scopeId, String elementId) {
            this.scopeId = scopeId;
            this.elementId = elementId;
        }

        public UUID getScopeId() {
            return this.scopeId;
        }

        public String getElementId() {
            return this.elementId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ForkKey that = (ForkKey)o;
            if (!this.scopeId.equals(that.scopeId)) {
                return false;
            }
            return this.elementId.equals(that.elementId);
        }

        public int hashCode() {
            int result = this.scopeId.hashCode();
            result = 31 * result + this.elementId.hashCode();
            return result;
        }
    }
}

