/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.state;

import io.takari.bpm.IndexedProcessDefinition;
import io.takari.bpm.api.ExecutionException;
import io.takari.bpm.api.Variables;
import io.takari.bpm.commands.CommandStack;
import io.takari.bpm.state.Activations;
import io.takari.bpm.state.Definitions;
import io.takari.bpm.state.Events;
import io.takari.bpm.state.Forks;
import io.takari.bpm.state.ProcessStatus;
import io.takari.bpm.state.Scopes;
import java.io.Serializable;
import java.util.UUID;

public class ProcessInstance
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final UUID id;
    private final String businessKey;
    private final Definitions definitions;
    private final ProcessStatus status;
    private final CommandStack stack;
    private final Variables variables;
    private final Activations activations;
    private final Forks forks;
    private final Scopes scopes;
    private final Events events;

    public ProcessInstance(UUID id, String businessKey, IndexedProcessDefinition definition, Variables variables) {
        this(id, businessKey, new Definitions(definition), ProcessStatus.RUNNING, new CommandStack(), variables, new Activations(), new Forks(), new Scopes(), new Events());
    }

    public ProcessInstance(UUID id, String businessKey, IndexedProcessDefinition definition) {
        this(id, businessKey, new Definitions(definition), ProcessStatus.RUNNING, new CommandStack(), new Variables(), new Activations(), new Forks(), new Scopes(), new Events());
    }

    private ProcessInstance(UUID id, String businessKey, Definitions definitions, ProcessStatus status, CommandStack stack, Variables variables, Activations activations, Forks forks, Scopes scopes, Events events) {
        this.id = id;
        this.businessKey = businessKey;
        this.definitions = definitions;
        this.status = status;
        this.stack = stack;
        this.variables = variables;
        this.activations = activations;
        this.forks = forks;
        this.scopes = scopes;
        this.events = events;
    }

    private ProcessInstance(ProcessInstance old, CommandStack stack) {
        this(old.id, old.businessKey, old.definitions, old.status, stack, old.variables, old.activations, old.forks, old.scopes, old.events);
    }

    private ProcessInstance(ProcessInstance old, ProcessStatus status) {
        this(old.id, old.businessKey, old.definitions, status, old.stack, old.variables, old.activations, old.forks, old.scopes, old.events);
    }

    private ProcessInstance(ProcessInstance old, Variables variables) {
        this(old.id, old.businessKey, old.definitions, old.status, old.stack, variables, old.activations, old.forks, old.scopes, old.events);
    }

    private ProcessInstance(ProcessInstance old, Definitions definitions) {
        this(old.id, old.businessKey, definitions, old.status, old.stack, old.variables, old.activations, old.forks, old.scopes, old.events);
    }

    private ProcessInstance(ProcessInstance old, Activations activations) {
        this(old.id, old.businessKey, old.definitions, old.status, old.stack, old.variables, activations, old.forks, old.scopes, old.events);
    }

    private ProcessInstance(ProcessInstance old, Forks forks) {
        this(old.id, old.businessKey, old.definitions, old.status, old.stack, old.variables, old.activations, forks, old.scopes, old.events);
    }

    private ProcessInstance(ProcessInstance old, Scopes scopes) {
        this(old.id, old.businessKey, old.definitions, old.status, old.stack, old.variables, old.activations, old.forks, scopes, old.events);
    }

    private ProcessInstance(ProcessInstance old, Events events) {
        this(old.id, old.businessKey, old.definitions, old.status, old.stack, old.variables, old.activations, old.forks, old.scopes, events);
    }

    public UUID getId() {
        return this.id;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public IndexedProcessDefinition getDefinition(String key) throws ExecutionException {
        IndexedProcessDefinition pd = this.definitions.get(key);
        if (pd == null) {
            throw new ExecutionException("Unknown process definition key: %s", new Object[]{key});
        }
        return pd;
    }

    public Definitions getDefinitions() {
        return this.definitions;
    }

    public ProcessInstance setDefinitions(Definitions defs) {
        return new ProcessInstance(this, defs);
    }

    public ProcessStatus getStatus() {
        return this.status;
    }

    public ProcessInstance setStatus(ProcessStatus status) {
        return new ProcessInstance(this, status);
    }

    public CommandStack getStack() {
        return this.stack;
    }

    public ProcessInstance setStack(CommandStack stack) {
        return new ProcessInstance(this, stack);
    }

    public Variables getVariables() {
        return this.variables;
    }

    public ProcessInstance setVariables(Variables variables) {
        return new ProcessInstance(this, variables);
    }

    public Activations getActivations() {
        return this.activations;
    }

    public ProcessInstance setActivations(Activations activations) {
        return new ProcessInstance(this, activations);
    }

    public Forks getForks() {
        return this.forks;
    }

    public ProcessInstance setForks(Forks forks) {
        return new ProcessInstance(this, forks);
    }

    public Scopes getScopes() {
        return this.scopes;
    }

    public ProcessInstance setScopes(Scopes scopes) {
        return new ProcessInstance(this, scopes);
    }

    public Events getEvents() {
        return this.events;
    }

    public ProcessInstance setEvents(Events events) {
        return new ProcessInstance(this, events);
    }
}

