/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.state;

import io.takari.bpm.IndexedProcessDefinition;
import io.takari.bpm.ProcessDefinitionUtils;
import io.takari.bpm.actions.Action;
import io.takari.bpm.actions.FireOnStartInterceptorsAction;
import io.takari.bpm.actions.PopScopeAction;
import io.takari.bpm.actions.PushScopeAction;
import io.takari.bpm.api.ExecutionException;
import io.takari.bpm.api.Variables;
import io.takari.bpm.commands.Command;
import io.takari.bpm.commands.CommandStack;
import io.takari.bpm.commands.PerformActionsCommand;
import io.takari.bpm.commands.ProcessElementCommand;
import io.takari.bpm.misc.CoverageIgnore;
import io.takari.bpm.model.StartEvent;
import io.takari.bpm.state.Activations;
import io.takari.bpm.state.Events;
import io.takari.bpm.state.ProcessInstance;
import io.takari.bpm.state.Scopes;
import io.takari.bpm.utils.MapUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StateHelper {
    private static final Logger log = LoggerFactory.getLogger(StateHelper.class);
    private static final boolean PRINT_ACTIVATIONS = false;

    public static ProcessInstance createInitialState(UUID id, String businessKey, IndexedProcessDefinition pd, Variables vars, Map<String, Object> args) throws ExecutionException {
        ProcessInstance state = new ProcessInstance(id, businessKey, pd, vars != null ? vars : new Variables());
        StartEvent start = ProcessDefinitionUtils.findStartEvent(pd);
        state = StateHelper.push(state, new PerformActionsCommand(new PopScopeAction()));
        state = StateHelper.push(state, new ProcessElementCommand(pd.getId(), start.getId()));
        state = StateHelper.push(state, new PerformActionsCommand(new PushScopeAction(pd.getId(), start.getId(), false)));
        state = StateHelper.applyArguments(state, pd.getAttributes(), args, false);
        state = StateHelper.push(state, new FireOnStartInterceptorsAction(pd.getId()));
        state = state.setVariables(state.getVariables().setVariable("__currentFlow", (Object)pd.getId()));
        return state;
    }

    public static ProcessInstance applyArguments(ProcessInstance state, Map<String, String> attr, Map<String, Object> args, boolean merge) {
        String k;
        Variables vars = state.getVariables();
        if (attr != null) {
            for (Map.Entry<String, Object> entry : attr.entrySet()) {
                k = "__attr_" + entry.getKey();
                vars = vars.setVariable(k, entry.getValue());
            }
        }
        if (args != null) {
            for (Map.Entry<String, Object> entry : args.entrySet()) {
                k = entry.getKey();
                Object a = vars.getVariable(k);
                Object b = entry.getValue();
                a = merge && a instanceof Map && b instanceof Map ? MapUtils.deepMerge((Map)a, (Map)b) : b;
                vars = vars.setVariable(k, a);
            }
        }
        vars = vars.setVariable("__processBusinessKey", (Object)state.getBusinessKey());
        return state.setVariables(vars);
    }

    public static ProcessInstance push(ProcessInstance state, Command cmd) {
        CommandStack stack = state.getStack();
        return state.setStack(stack.push(cmd));
    }

    public static ProcessInstance push(ProcessInstance state, Action ... actions) {
        CommandStack stack = state.getStack();
        return state.setStack(stack.push(new PerformActionsCommand(Arrays.asList(actions))));
    }

    @CoverageIgnore
    public static void dump(ProcessInstance state) {
        StringBuilder b = new StringBuilder();
        Collection<Command> commands = state.getStack().values();
        StateHelper.printCollection(b, commands);
        StateHelper.printScopes(b, state.getScopes());
        Map<UUID, Map<UUID, Events.EventRecord>> events = state.getEvents().values();
        StateHelper.printEvents(b, events);
        b.append("\n");
        log.trace("{}", (Object)b.toString());
    }

    @CoverageIgnore
    private static void printCollection(StringBuilder b, Collection<?> items) {
        b.append("\n=================================\n").append("\t").append("COMMANDS").append(": ").append(items.size()).append("\n");
        Iterator<?> i = items.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            b.append("\t\t").append(o);
            if (!i.hasNext()) continue;
            b.append("\n");
        }
    }

    @CoverageIgnore
    private static void printScopes(StringBuilder b, Scopes scopes) {
        Map<UUID, Scopes.Scope> items = scopes.values();
        b.append("\n=================================\n").append("\t").append("SCOPES").append(": ").append(items.size()).append("\n").append("\tCURRENT SCOPE: ").append(scopes.getCurrentId()).append("\n");
        for (Map.Entry<UUID, Scopes.Scope> e : items.entrySet()) {
            Scopes.Scope s = e.getValue();
            if (s.getParentId() != null) continue;
            StateHelper.printScopes(b, items, s.getId(), 2);
        }
        b.append("\tCURRENT SCOPE STACK:\n");
        UUID currentId = scopes.getCurrentId();
        if (currentId != null) {
            List<Scopes.Scope> stack = scopes.traverse(currentId);
            for (Scopes.Scope s : stack) {
                b.append("\t\t").append(s.getId()).append("=").append(s).append("\n");
            }
        }
    }

    @CoverageIgnore
    private static void printScopes(StringBuilder b, Map<UUID, Scopes.Scope> scopes, UUID rootId, int level) {
        int i = 0;
        while (i < level) {
            b.append("\t");
            ++i;
        }
        Scopes.Scope s = scopes.get(rootId);
        b.append(rootId).append("=").append(s).append("\n");
        for (Map.Entry<UUID, Scopes.Scope> e : scopes.entrySet()) {
            Scopes.Scope next = e.getValue();
            if (!rootId.equals(next.getParentId())) continue;
            StateHelper.printScopes(b, scopes, next.getId(), level + 1);
        }
    }

    @CoverageIgnore
    private static void printEvents(StringBuilder b, Map<UUID, Map<UUID, Events.EventRecord>> items) {
        b.append("\n=================================\n").append("\t").append("EVENTS").append(": ").append(items.size()).append("\n");
        for (Map.Entry<UUID, Map<UUID, Events.EventRecord>> e : items.entrySet()) {
            UUID k = e.getKey();
            Map<UUID, Events.EventRecord> v = e.getValue();
            if (v.isEmpty()) {
                b.append("\t\t").append(k).append(" = EMPTY\n");
                continue;
            }
            b.append("\t\t").append(k).append(" = {\n");
            for (Map.Entry<UUID, Events.EventRecord> ee : v.entrySet()) {
                UUID kk = ee.getKey();
                Events.EventRecord vv = ee.getValue();
                b.append("\t\t\t").append(kk).append("=").append(vv).append("\n");
            }
            b.append("\t\t}\n");
        }
    }

    @CoverageIgnore
    private static void printActivations(StringBuilder b, Map<Activations.ActivationKey, Activations.Activation> items) {
        b.append("\n=================================\n").append("\t").append("ACTIVATIONS").append(": ").append(items.size()).append("\n");
        for (Map.Entry<Activations.ActivationKey, Activations.Activation> e : items.entrySet()) {
            Activations.ActivationKey k = e.getKey();
            Activations.Activation v = e.getValue();
            b.append("\t\t").append(k.getScopeId()).append(" / ").append(k.getElementId()).append(" = ").append(v.getReceived()).append("/").append(v.getExpected()).append("\n");
        }
    }

    private StateHelper() {
    }
}

