/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm;

import io.takari.bpm.IndexedProcessDefinition;
import io.takari.bpm.ProcessDefinitionProvider;
import io.takari.bpm.api.ExecutionException;
import io.takari.bpm.model.ProcessDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexedProcessDefinitionProvider {
    private static final Logger log = LoggerFactory.getLogger(IndexedProcessDefinitionProvider.class);
    private final ProcessDefinitionProvider delegate;

    public IndexedProcessDefinitionProvider(ProcessDefinitionProvider delegate) {
        this.delegate = delegate;
    }

    public IndexedProcessDefinition getById(String id) throws ExecutionException {
        ProcessDefinition pd = this.delegate.getById(id);
        if (pd == null) {
            throw new ExecutionException("Process '%s' not found", new Object[]{id});
        }
        IndexedProcessDefinition ipd = new IndexedProcessDefinition(pd);
        log.debug("getById ['{}'] -> indexing done", (Object)id);
        return ipd;
    }
}

