/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.context;

import io.takari.bpm.actions.Action;
import io.takari.bpm.actions.SetVariableAction;
import io.takari.bpm.actions.UnsetVariableAction;
import io.takari.bpm.api.ExecutionContext;
import io.takari.bpm.api.ExecutionContextFactory;
import io.takari.bpm.api.Variables;
import io.takari.bpm.context.Change;
import io.takari.bpm.context.ChangeType;
import io.takari.bpm.el.ExpressionManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExecutionContextImpl
implements ExecutionContext {
    private final ExecutionContextFactory<? extends ExecutionContext> executionContextFactory;
    private final ExpressionManager exprManager;
    private final Variables source;
    private final Map<String, Change> changes = new HashMap<String, Change>();
    private String suspendMessageRef = null;
    private Object suspendPayload = null;
    private boolean resumeFromSameStep;
    private final String processDefinitionId;
    private final String elementId;

    public ExecutionContextImpl(ExecutionContextFactory<? extends ExecutionContext> executionContextFactory, ExpressionManager exprManager, Variables source) {
        this(executionContextFactory, exprManager, source, null, null);
    }

    public ExecutionContextImpl(ExecutionContextFactory<? extends ExecutionContext> executionContextFactory, ExpressionManager exprManager, Variables source, String processDefinitionId, String elementId) {
        this.executionContextFactory = executionContextFactory;
        this.exprManager = exprManager;
        this.source = source;
        this.processDefinitionId = processDefinitionId;
        this.elementId = elementId;
    }

    public <T> T eval(String expr, Class<T> type) {
        return this.exprManager.eval(this, expr, type);
    }

    public Object getVariable(String key) {
        return this.currentValue(key);
    }

    public Map<String, Object> getVariables() {
        return this.source.asMap();
    }

    public void setVariable(String key, Object value) {
        this.changes.put(key, new Change(ChangeType.SET, value));
    }

    public boolean hasVariable(String key) {
        Change c = this.changes.get(key);
        if (c != null && c.getType() == ChangeType.SET) {
            return true;
        }
        return this.source.hasVariable(key);
    }

    public void removeVariable(String key) {
        this.changes.put(key, new Change(ChangeType.UNSET, null));
    }

    public Set<String> getVariableNames() {
        return this.source.getVariableNames();
    }

    private Object currentValue(String key) {
        Change c = this.changes.get(key);
        if (c != null) {
            switch (c.getType()) {
                case SET: {
                    return c.getValue();
                }
                case UNSET: {
                    return null;
                }
            }
        }
        return this.source.getVariable(key);
    }

    public List<Action> toActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        for (Map.Entry<String, Change> e : this.changes.entrySet()) {
            String key = e.getKey();
            Change c = e.getValue();
            if (c.getType() == ChangeType.SET) {
                actions.add(new SetVariableAction(key, c.getValue()));
                continue;
            }
            if (c.getType() != ChangeType.UNSET) continue;
            actions.add(new UnsetVariableAction(key));
        }
        return actions;
    }

    public Variables toVariables() {
        Variables dst = this.source;
        for (Map.Entry<String, Change> e : this.changes.entrySet()) {
            String key = e.getKey();
            Change c = e.getValue();
            if (c.getType() == ChangeType.SET) {
                dst = dst.setVariable(key, c.getValue());
                continue;
            }
            if (c.getType() != ChangeType.UNSET) continue;
            dst = dst.removeVariable(key);
        }
        return dst;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (Variables variables : ExecutionContextImpl.stack(this.source)) {
            m.putAll(variables.asMap());
        }
        for (Map.Entry entry : this.changes.entrySet()) {
            String k = (String)entry.getKey();
            Change c = (Change)entry.getValue();
            if (c.getType() == ChangeType.SET) {
                m.put(k, c.getValue());
                continue;
            }
            if (c.getType() != ChangeType.UNSET) continue;
            m.remove(k);
        }
        return m;
    }

    public Object interpolate(Object v) {
        return this.exprManager.interpolate(this.executionContextFactory, this, v);
    }

    public void suspend(String messageRef) {
        this.suspendMessageRef = messageRef;
    }

    public void suspend(String messageRef, Object payload, boolean resumeFromSameStep) {
        this.suspendMessageRef = messageRef;
        this.suspendPayload = payload;
        this.resumeFromSameStep = resumeFromSameStep;
    }

    public String getSuspendMessageRef() {
        return this.suspendMessageRef;
    }

    public Object getSuspendPayload() {
        return this.suspendPayload;
    }

    public boolean isResumeFromSameStep() {
        return this.resumeFromSameStep;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getElementId() {
        return this.elementId;
    }

    private static List<Variables> stack(Variables tail) {
        ArrayList<Variables> l = new ArrayList<Variables>();
        for (Variables v = tail; v != null; v = v.getParent()) {
            l.add(v);
        }
        Collections.reverse(l);
        return l;
    }
}

