/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.el;

import io.takari.bpm.api.ExecutionContext;
import io.takari.bpm.el.ExecutionContextVariableResolver;
import io.takari.bpm.el.ExpressionManager;
import io.takari.bpm.task.ServiceTaskRegistry;
import io.takari.bpm.task.ServiceTaskResolver;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.StandardELContext;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExpressionManager
implements ExpressionManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultExpressionManager.class);
    private static final String[] DEFAULT_CONTEXT_VARIABLE_NAMES = new String[]{"execution"};
    private final String[] contextVariableNames;
    private final ExpressionFactory expressionFactory = ExpressionFactory.newInstance();
    protected final ELResolver[] resolvers;

    public DefaultExpressionManager(ServiceTaskRegistry serviceTaskRegistry) {
        this(DEFAULT_CONTEXT_VARIABLE_NAMES, serviceTaskRegistry);
    }

    public DefaultExpressionManager(String[] contextVariableNames, ServiceTaskRegistry serviceTaskRegistry) {
        this(contextVariableNames, new ServiceTaskResolver(serviceTaskRegistry));
    }

    public DefaultExpressionManager(ELResolver ... resolvers) {
        this(DEFAULT_CONTEXT_VARIABLE_NAMES, resolvers);
    }

    public DefaultExpressionManager(String[] contextVariableNames, ELResolver ... resolvers) {
        this.contextVariableNames = contextVariableNames;
        this.resolvers = resolvers;
    }

    @Override
    public <T> T eval(ExecutionContext ctx, String expr, Class<T> type) {
        try {
            ELResolver r = this.createResolver(ctx);
            StandardELContext sc = new StandardELContext(this.expressionFactory);
            sc.putContext(ExpressionFactory.class, (Object)this.expressionFactory);
            sc.addELResolver(r);
            VariableMapper vm = sc.getVariableMapper();
            String[] stringArray = this.contextVariableNames;
            int n = this.contextVariableNames.length;
            int n2 = 0;
            while (n2 < n) {
                String k = stringArray[n2];
                vm.setVariable(k, this.expressionFactory.createValueExpression((Object)ctx, ExecutionContext.class));
                ++n2;
            }
            ValueExpression x = this.expressionFactory.createValueExpression((ELContext)sc, expr, type);
            Object v = x.getValue((ELContext)sc);
            return type.cast(v);
        }
        catch (Exception e) {
            log.warn("eval ['{}'] -> error: {}", (Object)expr, (Object)e.getMessage());
            throw e;
        }
    }

    public static String quote(String s) {
        return s.replace("'", "'");
    }

    protected ELResolver createResolver(ExecutionContext ctx) {
        CompositeELResolver cr = new CompositeELResolver();
        ELResolver[] eLResolverArray = this.resolvers;
        int n = this.resolvers.length;
        int n2 = 0;
        while (n2 < n) {
            ELResolver r = eLResolverArray[n2];
            cr.add(r);
            ++n2;
        }
        cr.add((ELResolver)new ExecutionContextVariableResolver(ctx));
        return cr;
    }
}

