/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.elements;

import io.takari.bpm.Configuration;
import io.takari.bpm.IndexedProcessDefinition;
import io.takari.bpm.ProcessDefinitionUtils;
import io.takari.bpm.actions.Action;
import io.takari.bpm.actions.FindAndCallActivityAction;
import io.takari.bpm.actions.MakeSubProcessVariablesAction;
import io.takari.bpm.actions.PopCommandAction;
import io.takari.bpm.actions.PushCommandAction;
import io.takari.bpm.actions.PushScopeAction;
import io.takari.bpm.api.ExecutionException;
import io.takari.bpm.commands.ActivityFinalizerCommand;
import io.takari.bpm.commands.Command;
import io.takari.bpm.commands.MergeVariablesCommand;
import io.takari.bpm.commands.PerformActionsCommand;
import io.takari.bpm.commands.ProcessElementCommand;
import io.takari.bpm.elements.ElementHandler;
import io.takari.bpm.model.CallActivity;
import io.takari.bpm.model.VariableMapping;
import io.takari.bpm.state.ProcessInstance;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CallActivityHandler
implements ElementHandler {
    private final Configuration cfg;

    public CallActivityHandler(Configuration cfg) {
        this.cfg = cfg;
    }

    @Override
    public List<Action> handle(ProcessInstance state, ProcessElementCommand cmd, List<Action> actions) throws ExecutionException {
        actions.add(new PopCommandAction());
        ActivityFinalizerCommand errorHandlingCmd = new ActivityFinalizerCommand(cmd.getDefinitionId(), cmd.getElementId());
        actions.add(new PushCommandAction(errorHandlingCmd));
        ArrayList<Command> finishers = new ArrayList<Command>();
        finishers.add(errorHandlingCmd);
        IndexedProcessDefinition pd = state.getDefinition(cmd.getDefinitionId());
        CallActivity a = (CallActivity)ProcessDefinitionUtils.findElement(pd, cmd.getElementId());
        HashSet<VariableMapping> inVariables = a.getIn();
        if (inVariables == null) {
            inVariables = new HashSet<VariableMapping>();
        }
        inVariables.add(VariableMapping.copy((String)"__processBusinessKey", (String)"__processBusinessKey"));
        Set outVariables = a.getOut();
        actions.add(new MakeSubProcessVariablesAction(inVariables, a.isCopyAllVariables()));
        MergeVariablesCommand mergeCommand = new MergeVariablesCommand(state.getVariables(), outVariables, this.cfg.isCopyAllCallActivityOutVariables() && a.isCopyAllVariables());
        finishers.add(mergeCommand);
        actions.add(new PushCommandAction(mergeCommand));
        CallActivity e = (CallActivity)ProcessDefinitionUtils.findElement(pd, cmd.getElementId());
        actions.add(new FindAndCallActivityAction(e.getCalledElement(), e.getCalledElementExpression()));
        actions.add(new PushCommandAction(new PerformActionsCommand(new PushScopeAction(cmd.getDefinitionId(), cmd.getElementId(), false, finishers.toArray(new Command[0])))));
        return actions;
    }
}

