/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.elements;

import io.takari.bpm.Configuration;
import io.takari.bpm.IndexedProcessDefinition;
import io.takari.bpm.ProcessDefinitionUtils;
import io.takari.bpm.actions.Action;
import io.takari.bpm.api.ExecutionException;
import io.takari.bpm.commands.ProcessElementCommand;
import io.takari.bpm.elements.BoundaryEventHandler;
import io.takari.bpm.elements.CallActivityHandler;
import io.takari.bpm.elements.ElementHandler;
import io.takari.bpm.elements.EndEventHandler;
import io.takari.bpm.elements.EventBasedGatewayHandler;
import io.takari.bpm.elements.ExclusiveGatewayHandler;
import io.takari.bpm.elements.InclusiveGatewayHandler;
import io.takari.bpm.elements.IntermediateCatchEventHandler;
import io.takari.bpm.elements.ParallelGatewayHandler;
import io.takari.bpm.elements.ScriptTaskHandler;
import io.takari.bpm.elements.SequenceFlowHandler;
import io.takari.bpm.elements.ServiceTaskHandler;
import io.takari.bpm.elements.StartEventHandler;
import io.takari.bpm.elements.SubProcessHandler;
import io.takari.bpm.elements.TerminateEventHandler;
import io.takari.bpm.elements.UserTaskElementHandler;
import io.takari.bpm.model.AbstractElement;
import io.takari.bpm.model.BoundaryEvent;
import io.takari.bpm.model.CallActivity;
import io.takari.bpm.model.EndEvent;
import io.takari.bpm.model.EventBasedGateway;
import io.takari.bpm.model.ExclusiveGateway;
import io.takari.bpm.model.InclusiveGateway;
import io.takari.bpm.model.IntermediateCatchEvent;
import io.takari.bpm.model.ParallelGateway;
import io.takari.bpm.model.ScriptTask;
import io.takari.bpm.model.SequenceFlow;
import io.takari.bpm.model.ServiceTask;
import io.takari.bpm.model.StartEvent;
import io.takari.bpm.model.SubProcess;
import io.takari.bpm.model.TerminateEvent;
import io.takari.bpm.model.UserTask;
import io.takari.bpm.state.ProcessInstance;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingElementHandler
implements ElementHandler {
    private static final Logger log = LoggerFactory.getLogger(DelegatingElementHandler.class);
    private final Map<Class<? extends AbstractElement>, ElementHandler> delegates = new HashMap<Class<? extends AbstractElement>, ElementHandler>();

    public DelegatingElementHandler(Configuration cfg) {
        this.delegates.put(StartEvent.class, new StartEventHandler());
        this.delegates.put(EndEvent.class, new EndEventHandler());
        this.delegates.put(TerminateEvent.class, new TerminateEventHandler());
        this.delegates.put(SequenceFlow.class, new SequenceFlowHandler());
        this.delegates.put(ServiceTask.class, new ServiceTaskHandler());
        this.delegates.put(BoundaryEvent.class, new BoundaryEventHandler());
        this.delegates.put(SubProcess.class, new SubProcessHandler());
        this.delegates.put(CallActivity.class, new CallActivityHandler(cfg));
        this.delegates.put(IntermediateCatchEvent.class, new IntermediateCatchEventHandler());
        this.delegates.put(EventBasedGateway.class, new EventBasedGatewayHandler());
        this.delegates.put(ExclusiveGateway.class, new ExclusiveGatewayHandler());
        this.delegates.put(ParallelGateway.class, new ParallelGatewayHandler());
        this.delegates.put(InclusiveGateway.class, new InclusiveGatewayHandler());
        this.delegates.put(UserTask.class, new UserTaskElementHandler());
        this.delegates.put(ScriptTask.class, new ScriptTaskHandler());
    }

    @Override
    public List<Action> handle(ProcessInstance state, ProcessElementCommand cmd, List<Action> actions) throws ExecutionException {
        IndexedProcessDefinition pd = state.getDefinition(cmd.getDefinitionId());
        AbstractElement e = ProcessDefinitionUtils.findElement(pd, cmd.getElementId());
        ElementHandler delegate = this.delegates.get(e.getClass());
        if (delegate == null) {
            throw new ExecutionException("Unsupported element: %s", new Object[]{e});
        }
        actions = delegate.handle(state, cmd, actions);
        log.debug("handle ['{}', '{}'] -> done", (Object)state.getBusinessKey(), (Object)cmd.getElementId());
        return actions;
    }
}

