/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.elements;

import io.takari.bpm.IndexedProcessDefinition;
import io.takari.bpm.ProcessDefinitionUtils;
import io.takari.bpm.actions.Action;
import io.takari.bpm.actions.ParallelForkAction;
import io.takari.bpm.actions.PopCommandAction;
import io.takari.bpm.actions.PushCommandAction;
import io.takari.bpm.api.ExecutionException;
import io.takari.bpm.commands.PerformActionsCommand;
import io.takari.bpm.commands.ProcessElementCommand;
import io.takari.bpm.elements.ElementHandler;
import io.takari.bpm.model.SequenceFlow;
import io.takari.bpm.state.Activations;
import io.takari.bpm.state.ProcessInstance;
import io.takari.bpm.state.Scopes;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelGatewayHandler
implements ElementHandler {
    private static final Logger log = LoggerFactory.getLogger(ParallelGatewayHandler.class);

    @Override
    public List<Action> handle(ProcessInstance state, ProcessElementCommand cmd, List<Action> actions) throws ExecutionException {
        actions.add(new PopCommandAction());
        Activations acts = state.getActivations();
        Scopes scopes = state.getScopes();
        UUID scopeId = scopes.getCurrentId();
        IndexedProcessDefinition pd = state.getDefinition(cmd.getDefinitionId());
        List<SequenceFlow> in = ProcessDefinitionUtils.findIncomingFlows(pd, cmd.getElementId());
        log.debug("Handling parallel {} in {}", (Object)cmd.getElementId(), (Object)scopeId);
        ArrayList<Activations.Activation> awaiting = new ArrayList<Activations.Activation>();
        boolean containsInactive = false;
        boolean containsIncomplete = false;
        for (SequenceFlow flow : in) {
            Activations.Activation act = acts.getActivation(scopes, scopeId, flow.getId());
            if (!act.isActivated()) {
                containsInactive = true;
                awaiting.add(act);
                log.debug("  Inactive {}", (Object)act);
                continue;
            }
            if (act.getReceived() < act.getExpected()) {
                containsIncomplete = true;
                awaiting.add(act);
                log.debug("  Incomplete {}", (Object)act);
                continue;
            }
            if (act.getReceived() > act.getExpected()) {
                throw new ExecutionException("Incorrect number of activations for the element '%s' in the process '%s': expected %d, got %d", new Object[]{cmd.getElementId(), cmd.getDefinitionId(), act.getExpected(), act.getReceived()});
            }
            log.debug("  Completed {}", (Object)act);
        }
        if (!containsInactive && !containsIncomplete) {
            log.debug("  All activations complete, resuming");
            Action a = this.createForkAction(cmd);
            actions.add(new PushCommandAction(new PerformActionsCommand(a)));
        }
        return actions;
    }

    protected Action createForkAction(ProcessElementCommand cmd) {
        return new ParallelForkAction(cmd.getDefinitionId(), cmd.getElementId());
    }
}

