/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.reducers;

import io.takari.bpm.IndexedProcessDefinition;
import io.takari.bpm.ProcessDefinitionUtils;
import io.takari.bpm.actions.Action;
import io.takari.bpm.actions.EvaluateAndFollowFlowsAction;
import io.takari.bpm.api.ExecutionContext;
import io.takari.bpm.api.ExecutionContextFactory;
import io.takari.bpm.api.ExecutionException;
import io.takari.bpm.commands.CommandStack;
import io.takari.bpm.commands.ProcessElementCommand;
import io.takari.bpm.model.SequenceFlow;
import io.takari.bpm.reducers.Impure;
import io.takari.bpm.reducers.Reducer;
import io.takari.bpm.state.ProcessInstance;
import java.util.ArrayList;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Impure
public class EvaluatedFlowsReducer
implements Reducer {
    private static final Logger log = LoggerFactory.getLogger(EvaluatedFlowsReducer.class);
    private final ExecutionContextFactory<?> contextFactory;

    public EvaluatedFlowsReducer(ExecutionContextFactory<?> contextFactory) {
        this.contextFactory = contextFactory;
    }

    @Override
    public ProcessInstance reduce(ProcessInstance state, Action action) throws ExecutionException {
        if (!(action instanceof EvaluateAndFollowFlowsAction)) {
            return state;
        }
        EvaluateAndFollowFlowsAction a = (EvaluateAndFollowFlowsAction)action;
        String nextId = null;
        IndexedProcessDefinition pd = state.getDefinition(a.getDefinitionId());
        ArrayList<SequenceFlow> flows = new ArrayList<SequenceFlow>(ProcessDefinitionUtils.findOutgoingFlows(pd, a.getElementId()));
        ExecutionContext ctx = this.contextFactory.create(state.getVariables(), a.getDefinitionId(), a.getElementId());
        Iterator i = flows.iterator();
        while (i.hasNext()) {
            SequenceFlow f = (SequenceFlow)i.next();
            if (f.getExpression() == null) continue;
            i.remove();
            if (!EvaluatedFlowsReducer.eval(ctx, f)) continue;
            nextId = f.getId();
            break;
        }
        if (nextId == null && !flows.isEmpty()) {
            String defaultFlow = a.getDefaultFlow();
            if (defaultFlow != null) {
                for (SequenceFlow f : flows) {
                    if (!f.getId().equals(defaultFlow)) continue;
                    nextId = f.getId();
                    break;
                }
            } else {
                nextId = ((SequenceFlow)flows.iterator().next()).getId();
            }
        }
        if (nextId == null) {
            throw new ExecutionException("No valid outgoing flows for '%s' and no default flow", new Object[]{a.getElementId()});
        }
        CommandStack stack = state.getStack();
        state = state.setStack(stack.push(new ProcessElementCommand(pd.getId(), nextId)));
        state = EvaluatedFlowsReducer.activateUnusedFlows(state, a.getDefinitionId(), a.getElementId(), nextId);
        return state;
    }

    private static boolean eval(ExecutionContext ctx, SequenceFlow f) throws ExecutionException {
        String expr = f.getExpression();
        Boolean b = (Boolean)ctx.eval(expr, Boolean.class);
        if (b == null) {
            throw new ExecutionException("'{}' expected a boolean value, got null. Possibly undefined variable.", new Object[]{expr});
        }
        log.debug("eval ['{}', '{}'] -> {}", new Object[]{f.getId(), f.getExpression(), b});
        return b;
    }

    private static ProcessInstance activateUnusedFlows(ProcessInstance state, String definitionId, String elementId, String usedFlowId) throws ExecutionException {
        IndexedProcessDefinition pd = state.getDefinition(definitionId);
        for (SequenceFlow f : ProcessDefinitionUtils.findOutgoingFlows(pd, elementId)) {
            if (f.getId().equals(usedFlowId)) continue;
            state = ProcessDefinitionUtils.activateGatewayFlow(state, pd, elementId, -1);
            log.debug("activateUnusedFlows ['{}', '{}', '{}'] -> single activation of '{}'", new Object[]{state.getBusinessKey(), definitionId, elementId, f.getId()});
        }
        return state;
    }
}

