/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.reducers;

import io.takari.bpm.Configuration;
import io.takari.bpm.actions.Action;
import io.takari.bpm.actions.EvalExpressionAction;
import io.takari.bpm.api.BpmnError;
import io.takari.bpm.api.ExecutionContext;
import io.takari.bpm.api.ExecutionContextFactory;
import io.takari.bpm.api.ExecutionException;
import io.takari.bpm.api.Variables;
import io.takari.bpm.commands.Command;
import io.takari.bpm.context.ContextUtils;
import io.takari.bpm.context.ExecutionContextImpl;
import io.takari.bpm.model.ExpressionType;
import io.takari.bpm.reducers.BpmnErrorHandlingReducer;
import io.takari.bpm.state.ProcessInstance;
import io.takari.bpm.state.VariablesHelper;
import io.takari.bpm.task.JavaDelegateHandler;
import io.takari.bpm.utils.TimeoutCallable;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import javax.el.ELException;

public class ExpressionsReducer
extends BpmnErrorHandlingReducer {
    private final ExecutionContextFactory<? extends ExecutionContextImpl> contextFactory;
    private final Configuration cfg;
    private final JavaDelegateHandler javaDelegateHandler;
    private final ExecutorService executor;

    public ExpressionsReducer(ExecutionContextFactory<? extends ExecutionContextImpl> contextFactory, Configuration cfg, JavaDelegateHandler javaDelegateHandler, ExecutorService executor) {
        super(cfg);
        this.contextFactory = contextFactory;
        this.cfg = cfg;
        this.javaDelegateHandler = javaDelegateHandler;
        this.executor = executor;
    }

    @Override
    public ProcessInstance reduce(ProcessInstance state, Action action) throws ExecutionException {
        if (!(action instanceof EvalExpressionAction)) {
            return state;
        }
        EvalExpressionAction a = (EvalExpressionAction)action;
        boolean hasError = false;
        ExecutionContextImpl ctx = null;
        try {
            Variables vars = VariablesHelper.applyInVariables(this.contextFactory, state.getVariables(), a.getIn(), a.isCopyAllVariables());
            ctx = (ExecutionContextImpl)this.contextFactory.create(vars, a.getDefinitionId(), a.getElementId());
            boolean storeResult = this.cfg.isStoreExpressionEvalResultsInContext();
            Callable<Command> fn = new DelegateFn(this.javaDelegateHandler, ctx, a.getType(), a.getExpression(), a.getDefaultCommand(), storeResult);
            List timeouts = a.getTimeouts();
            if (timeouts != null && !timeouts.isEmpty()) {
                fn = new TimeoutCallable<Command>(this.executor, timeouts, fn);
            }
            Command next = (Command)fn.call();
            state = ContextUtils.handleSuspend(state, ctx, a.getDefinitionId(), a.getElementId(), next);
        }
        catch (ELException e) {
            Throwable cause = e.getCause();
            state = cause instanceof BpmnError ? this.handleBpmnError(state, a, (BpmnError)cause) : this.handleException(state, a, (Exception)((Object)e));
            hasError = true;
        }
        catch (BpmnError e) {
            state = this.handleBpmnError(state, a, e);
            hasError = true;
        }
        catch (ExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            state = this.handleException(state, a, e);
            hasError = true;
        }
        boolean ignoreMappingErrors = hasError;
        state = VariablesHelper.applyOutVariables(this.contextFactory, state, ctx, a.getOut(), ignoreMappingErrors);
        return state;
    }

    private ProcessInstance handleException(ProcessInstance state, EvalExpressionAction a, Exception e) throws ExecutionException {
        return this.handleException(state, a.getDefinitionId(), a.getElementId(), e, a.getErrors(), a.getDefaultError());
    }

    private ProcessInstance handleBpmnError(ProcessInstance state, EvalExpressionAction a, BpmnError e) throws ExecutionException {
        return this.handleBpmnError(state, a.getDefinitionId(), a.getElementId(), e, a.getErrors(), a.getDefaultError());
    }

    private static final class DelegateFn
    implements Callable<Command> {
        private final JavaDelegateHandler javaDelegateHandler;
        private final ExecutionContext ctx;
        private final ExpressionType type;
        private final String expression;
        private final Command defaultCommand;
        private final boolean storeResult;

        public DelegateFn(JavaDelegateHandler javaDelegateHandler, ExecutionContext ctx, ExpressionType type, String expression, Command defaultCommand, boolean storeResult) {
            this.javaDelegateHandler = javaDelegateHandler;
            this.ctx = ctx;
            this.type = type;
            this.expression = expression;
            this.defaultCommand = defaultCommand;
            this.storeResult = storeResult;
        }

        @Override
        public Command call() throws Exception {
            Object v = this.ctx.eval(this.expression, Object.class);
            if (this.type == ExpressionType.DELEGATE) {
                this.javaDelegateHandler.execute(v, this.ctx);
            } else if (this.storeResult) {
                this.ctx.setVariable("__exprResult", v);
            }
            return this.defaultCommand;
        }
    }
}

