/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.reducers;

import io.takari.bpm.IndexedProcessDefinition;
import io.takari.bpm.ProcessDefinitionUtils;
import io.takari.bpm.actions.Action;
import io.takari.bpm.actions.ActivateFlowsAction;
import io.takari.bpm.actions.CommenceForkAction;
import io.takari.bpm.actions.FollowFlowsAction;
import io.takari.bpm.actions.InclusiveForkAction;
import io.takari.bpm.actions.ParallelForkAction;
import io.takari.bpm.actions.PopScopeAction;
import io.takari.bpm.actions.PushScopeAction;
import io.takari.bpm.api.ExecutionContext;
import io.takari.bpm.api.ExecutionContextFactory;
import io.takari.bpm.api.ExecutionException;
import io.takari.bpm.commands.CommandStack;
import io.takari.bpm.commands.PerformActionsCommand;
import io.takari.bpm.model.SequenceFlow;
import io.takari.bpm.reducers.Impure;
import io.takari.bpm.reducers.Reducer;
import io.takari.bpm.state.Forks;
import io.takari.bpm.state.ProcessInstance;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Impure
public class ForkReducer
implements Reducer {
    private static final Logger log = LoggerFactory.getLogger(ForkReducer.class);
    private final ExecutionContextFactory<?> contextFactory;

    public ForkReducer(ExecutionContextFactory<?> contextFactory) {
        this.contextFactory = contextFactory;
    }

    @Override
    public ProcessInstance reduce(ProcessInstance state, Action action) throws ExecutionException {
        if (action instanceof ParallelForkAction) {
            ParallelForkAction a = (ParallelForkAction)action;
            IndexedProcessDefinition pd = state.getDefinition(a.getDefinitionId());
            List<SequenceFlow> out = ProcessDefinitionUtils.findOutgoingFlows(pd, a.getElementId());
            return ForkReducer.follow(pd, state, a.getDefinitionId(), a.getElementId(), out, null);
        }
        if (action instanceof InclusiveForkAction) {
            InclusiveForkAction a = (InclusiveForkAction)action;
            IndexedProcessDefinition pd = state.getDefinition(a.getDefinitionId());
            List<SequenceFlow> out = ProcessDefinitionUtils.findOutgoingFlows(pd, a.getElementId());
            ExecutionContext ctx = this.contextFactory.create(state.getVariables(), a.getDefinitionId(), a.getElementId());
            List<SequenceFlow> filtered = ForkReducer.filterInactive(ctx, out);
            ArrayList<SequenceFlow> inactive = new ArrayList<SequenceFlow>(out);
            inactive.removeAll(filtered);
            return ForkReducer.follow(pd, state, a.getDefinitionId(), a.getElementId(), filtered, inactive);
        }
        if (action instanceof CommenceForkAction) {
            CommenceForkAction a = (CommenceForkAction)action;
            Forks forks = state.getForks();
            UUID scopeId = state.getScopes().getCurrentId();
            Forks.Fork fork = forks.getFork(scopeId, a.getElementId());
            ActivateFlowsAction activateFlows = ActivateFlowsAction.empty(a.getDefinitionId());
            ArrayList<String> flows = new ArrayList<String>();
            ArrayList<Action> actions = new ArrayList<Action>();
            for (String flowId : fork.getFlows()) {
                int count = fork.getFlowCount(flowId);
                activateFlows = activateFlows.addFlow(flowId, count);
                int i = 0;
                while (i < count) {
                    flows.add(flowId);
                    ++i;
                }
            }
            actions.add(activateFlows);
            actions.add(new FollowFlowsAction(a.getDefinitionId(), a.getElementId(), flows));
            CommandStack stack = state.getStack().push(new PerformActionsCommand(new PopScopeAction())).push(new PerformActionsCommand(actions)).push(new PerformActionsCommand(new PushScopeAction(a.getDefinitionId(), a.getElementId(), false)));
            return state.setForks(forks.removeFork(scopeId, a.getElementId())).setStack(stack);
        }
        return state;
    }

    private static ProcessInstance follow(IndexedProcessDefinition pd, ProcessInstance state, String definitionId, String elementId, List<SequenceFlow> flows, List<SequenceFlow> inactiveFlows) throws ExecutionException {
        SequenceFlow ff;
        CommandStack stack = state.getStack();
        Forks forks = state.getForks();
        UUID scopeId = state.getScopes().getCurrentId();
        if (!state.getForks().containsFork(scopeId, elementId)) {
            stack = stack.push(new PerformActionsCommand(new CommenceForkAction(definitionId, elementId)));
        }
        if (flows.size() > 0 && ProcessDefinitionUtils.isTracedToElement(pd, (ff = flows.get(0)).getId(), elementId)) {
            flows.remove(0);
            stack = stack.push(new PerformActionsCommand(Arrays.asList(new ActivateFlowsAction(definitionId, ff.getId(), 1), new FollowFlowsAction(definitionId, elementId, Collections.singletonList(ff.getId())))));
        }
        for (SequenceFlow flow : flows) {
            forks = forks.incrementFlow(scopeId, elementId, flow.getId(), 1);
        }
        if (inactiveFlows != null) {
            for (SequenceFlow flow : inactiveFlows) {
                forks = forks.incrementFlow(scopeId, elementId, flow.getId(), 0);
            }
        }
        return state.setForks(forks).setStack(stack);
    }

    private static List<SequenceFlow> filterInactive(ExecutionContext ctx, List<SequenceFlow> flows) throws ExecutionException {
        ArrayList<SequenceFlow> result = new ArrayList<SequenceFlow>(flows);
        Iterator i = result.iterator();
        while (i.hasNext()) {
            SequenceFlow f = (SequenceFlow)i.next();
            if (f.getExpression() == null) continue;
            String expr = f.getExpression();
            Boolean b = (Boolean)ctx.eval(expr, Boolean.class);
            if (b == null) {
                throw new ExecutionException("'{}' expected a boolean value, got null. Possibly undefined variable.", new Object[]{expr});
            }
            if (b.booleanValue()) continue;
            i.remove();
        }
        return result;
    }
}

