/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.state;

import io.takari.bpm.actions.Action;
import io.takari.bpm.api.ExecutionContext;
import io.takari.bpm.api.ExecutionContextFactory;
import io.takari.bpm.api.Variables;
import io.takari.bpm.commands.PerformActionsCommand;
import io.takari.bpm.context.ExecutionContextImpl;
import io.takari.bpm.misc.CoverageIgnore;
import io.takari.bpm.model.VariableMapping;
import io.takari.bpm.state.ProcessInstance;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.el.PropertyNotFoundException;

public final class VariablesHelper {
    public static Variables copyVariables(ExecutionContextFactory<?> contextFactory, Variables src, Variables dst, Set<VariableMapping> mapping) {
        return VariablesHelper.copyVariables(contextFactory, src, dst, mapping, false);
    }

    public static Variables copyVariables(ExecutionContextFactory<?> contextFactory, Variables src, Variables dst, Set<VariableMapping> mapping, boolean ignoreMappingErrors) {
        if (mapping == null) {
            return dst;
        }
        for (VariableMapping m : mapping) {
            String source = m.getSource();
            String sourceExpression = m.getSourceExpression();
            Object sourceValue = m.getSourceValue();
            try {
                ExecutionContext ctx;
                Object v = null;
                if (sourceValue != null) {
                    if (m.isInterpolateValue()) {
                        ctx = contextFactory.create(src);
                        v = ctx.interpolate(sourceValue);
                    } else {
                        v = sourceValue;
                    }
                } else if (source != null) {
                    v = src.getVariable(source);
                } else if (sourceExpression != null) {
                    ctx = contextFactory.create(src);
                    v = ctx.eval(sourceExpression, Object.class);
                }
                dst = dst.setVariable(m.getTarget(), v);
            }
            catch (PropertyNotFoundException e) {
                if (ignoreMappingErrors) continue;
                throw e;
            }
        }
        return dst;
    }

    public static Variables copyVariables(Variables src, Variables dst) {
        Set keys = src.getVariableNames();
        for (String k : keys) {
            Object v = src.getVariable(k);
            dst = dst.setVariable(k, v);
        }
        return dst;
    }

    public static Variables applyInVariables(ExecutionContextFactory<?> contextFactory, Variables src, Set<VariableMapping> in, boolean appendCurrentVariablesIntoInVariables) {
        if (in == null) {
            return src;
        }
        Variables parentVariables = null;
        if (appendCurrentVariablesIntoInVariables) {
            parentVariables = src;
        }
        return VariablesHelper.copyVariables(contextFactory, src, new Variables(parentVariables), in);
    }

    public static ProcessInstance applyOutVariables(ExecutionContextFactory<?> contextFactory, ProcessInstance state, ExecutionContextImpl ctx, Set<VariableMapping> out) {
        return VariablesHelper.applyOutVariables(contextFactory, state, ctx, out, false);
    }

    public static ProcessInstance applyOutVariables(ExecutionContextFactory<?> contextFactory, ProcessInstance state, ExecutionContextImpl ctx, Set<VariableMapping> out, boolean ignoreMappingErrors) {
        if (ctx == null) {
            return state;
        }
        if (out != null) {
            Variables src = ctx.toVariables();
            Variables dst = VariablesHelper.copyVariables(contextFactory, src, state.getVariables(), out, ignoreMappingErrors);
            return state.setVariables(dst);
        }
        List<Action> actions = ctx.toActions();
        if (actions == null || actions.isEmpty()) {
            return state;
        }
        PerformActionsCommand cmd = new PerformActionsCommand(actions);
        return state.setStack(state.getStack().push(cmd));
    }

    public static ProcessInstance interpolate(ExecutionContextFactory<?> contextFactory, ProcessInstance state) {
        Variables vars = state.getVariables();
        ExecutionContext ctx = contextFactory.create(vars);
        Map m = new LinkedHashMap(vars.asMap());
        m = (Map)ctx.interpolate(m);
        Variables interpolated = new Variables(vars.getParent()).setVariables(m);
        return state.setVariables(interpolated);
    }

    @CoverageIgnore
    private VariablesHelper() {
    }
}

