/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm;

import io.takari.bpm.Configuration;
import io.takari.bpm.EngineListenerHolder;
import io.takari.bpm.ExecutionInterceptorHolder;
import io.takari.bpm.Executor;
import io.takari.bpm.IndexedProcessDefinition;
import io.takari.bpm.IndexedProcessDefinitionProvider;
import io.takari.bpm.UuidGenerator;
import io.takari.bpm.actions.Action;
import io.takari.bpm.actions.FireOnFailureInterceptorsAction;
import io.takari.bpm.actions.FireOnFinishInterceptorsAction;
import io.takari.bpm.actions.FireOnResumeInterceptorsAction;
import io.takari.bpm.actions.FireOnSuspendInterceptorsAction;
import io.takari.bpm.actions.FireOnUnhandledErrorAction;
import io.takari.bpm.actions.InterpolateCurrentVariablesAction;
import io.takari.bpm.api.BpmnError;
import io.takari.bpm.api.Engine;
import io.takari.bpm.api.ExecutionException;
import io.takari.bpm.api.NoEventFoundException;
import io.takari.bpm.api.Variables;
import io.takari.bpm.api.interceptors.ExecutionInterceptor;
import io.takari.bpm.event.Event;
import io.takari.bpm.event.EventPersistenceManager;
import io.takari.bpm.lock.LockManager;
import io.takari.bpm.persistence.PersistenceManager;
import io.takari.bpm.planner.Planner;
import io.takari.bpm.state.BpmnErrorHelper;
import io.takari.bpm.state.Events;
import io.takari.bpm.state.ProcessInstance;
import io.takari.bpm.state.ProcessStatus;
import io.takari.bpm.state.StateHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEngine
implements Engine {
    private static final Logger log = LoggerFactory.getLogger(AbstractEngine.class);

    protected abstract IndexedProcessDefinitionProvider getProcessDefinitionProvider();

    protected abstract UuidGenerator getUuidGenerator();

    protected abstract Planner getPlanner();

    protected abstract Executor getExecutor();

    protected abstract PersistenceManager getPersistenceManager();

    protected abstract ExecutionInterceptorHolder getInterceptorHolder();

    protected abstract EngineListenerHolder getListenerHolder();

    protected abstract EventPersistenceManager getEventManager();

    protected abstract LockManager getLockManager();

    protected abstract Configuration getConfiguration();

    public void start(String processBusinessKey, String processDefinitionId, Map<String, Object> arguments) throws ExecutionException {
        this.start(processBusinessKey, processDefinitionId, new Variables(), arguments);
    }

    public void start(String processBusinessKey, String processDefinitionId, Variables variables, Map<String, Object> arguments) throws ExecutionException {
        IndexedProcessDefinitionProvider pdp = this.getProcessDefinitionProvider();
        IndexedProcessDefinition pd = pdp.getById(processDefinitionId);
        UuidGenerator idg = this.getUuidGenerator();
        UUID instanceId = idg.generate();
        ProcessInstance state = StateHelper.createInitialState(instanceId, processBusinessKey, pd, variables, arguments);
        LockManager lm = this.getLockManager();
        lm.lock(processBusinessKey);
        if (this.getConfiguration().isInterpolateInputVariables()) {
            state = StateHelper.push(state, new InterpolateCurrentVariablesAction());
        }
        try {
            try {
                this.runLockSafe(state);
            }
            catch (Exception e) {
                UUID scopeId = state.getScopes().getCurrentId();
                this.getInterceptorHolder().fireOnError(processBusinessKey, pd.getId(), state.getId(), scopeId, e);
                throw e;
            }
        }
        finally {
            lm.unlock(processBusinessKey);
        }
    }

    public void resume(String processBusinessKey, String eventName, Map<String, Object> variables, boolean merge) throws ExecutionException {
        LockManager lm = this.getLockManager();
        lm.lock(processBusinessKey);
        try {
            try {
                EventPersistenceManager em = this.getEventManager();
                Collection<Event> evs = em.find(processBusinessKey, eventName);
                if (evs == null || evs.isEmpty()) {
                    throw new NoEventFoundException("No event '%s' found for process '%s'", new Object[]{eventName, processBusinessKey});
                }
                if (evs.size() > 1) {
                    StringBuilder b = new StringBuilder();
                    for (Event e : evs) {
                        b.append(e).append(",");
                    }
                    throw new ExecutionException("Non-unique event name in process '%s': %s. Events: %s", new Object[]{processBusinessKey, eventName, b});
                }
                Event e = evs.iterator().next();
                this.resumeLockSafe(e, variables, merge);
            }
            catch (Exception e) {
                this.getInterceptorHolder().fireOnError(processBusinessKey, null, null, null, e);
                throw e;
            }
        }
        finally {
            lm.unlock(processBusinessKey);
        }
    }

    public void resume(String processBusinessKey, String eventName, Map<String, Object> variables) throws ExecutionException {
        this.resume(processBusinessKey, eventName, variables, false);
    }

    public void resume(UUID eventId, Map<String, Object> variables, boolean merge) throws ExecutionException {
        EventPersistenceManager em = this.getEventManager();
        Event ev = em.get(eventId);
        if (ev == null) {
            throw new NoEventFoundException("No event '%s' found", new Object[]{eventId});
        }
        String businessKey = ev.getProcessBusinessKey();
        LockManager lm = this.getLockManager();
        lm.lock(businessKey);
        try {
            try {
                this.resumeLockSafe(ev, variables, merge);
            }
            catch (Exception e) {
                this.getInterceptorHolder().fireOnError(businessKey, ev.getDefinitionId(), ev.getExecutionId(), null, e);
                throw e;
            }
        }
        finally {
            lm.unlock(businessKey);
        }
    }

    public void resume(UUID eventId, Map<String, Object> variables) throws ExecutionException {
        this.resume(eventId, variables, false);
    }

    public void addInterceptor(ExecutionInterceptor i) {
        this.getInterceptorHolder().addInterceptor(i);
    }

    private void resumeLockSafe(Event e, Map<String, Object> variables, boolean merge) throws ExecutionException {
        String businessKey = e.getProcessBusinessKey();
        String eventName = e.getName();
        UUID eid = e.getExecutionId();
        log.debug("resumeLockSafe ['{}', '{}'] -> got '{}'", new Object[]{businessKey, eventName, eid});
        EventPersistenceManager em = this.getEventManager();
        if (e.isExclusive()) {
            em.clearGroup(businessKey, e.getScopeId());
        } else {
            em.remove(e.getId());
        }
        PersistenceManager pm = this.getPersistenceManager();
        ProcessInstance state = pm.get(eid);
        if (state == null) {
            throw new ExecutionException("No execution '%s' found for the process '%s'", new Object[]{eid, businessKey});
        }
        state = state.setStatus(ProcessStatus.RUNNING);
        state = StateHelper.applyArguments(state, null, variables, merge);
        state = this.getExecutor().eval(state, Collections.singletonList(new FireOnResumeInterceptorsAction()));
        state = AbstractEngine.pushEventCommands(state, e);
        this.runLockSafe(state);
    }

    public void run(ProcessInstance state) throws ExecutionException {
        LockManager lm = this.getLockManager();
        lm.lock(state.getBusinessKey());
        try {
            this.runLockSafe(state);
        }
        finally {
            lm.unlock(state.getBusinessKey());
        }
    }

    private void runLockSafe(ProcessInstance state) throws ExecutionException {
        log.debug("runLockSafe ['{}'] -> started...", (Object)state.getBusinessKey());
        try {
            while (state.getStatus() == ProcessStatus.RUNNING) {
                if (log.isTraceEnabled()) {
                    StateHelper.dump(state);
                }
                List<Action> actions = this.getPlanner().eval(state);
                state = this.getExecutor().eval(state, actions);
            }
        }
        catch (Exception e) {
            this.getListenerHolder().fireOnUnhandledException(state);
            throw e;
        }
        state = this.getListenerHolder().fireOnFinalize(state);
        ProcessStatus status = state.getStatus();
        BpmnError raisedError = BpmnErrorHelper.getRaisedError(state.getVariables());
        if (status == ProcessStatus.SUSPENDED) {
            if (raisedError != null) {
                state = this.getExecutor().eval(state, Collections.singletonList(new FireOnUnhandledErrorAction(raisedError)));
                log.debug("runLockSafe ['{}'] -> failed with '{}'", new Object[]{state.getBusinessKey(), raisedError.getErrorRef(), raisedError.getCause()});
            }
            state = this.getExecutor().eval(state, Collections.singletonList(new FireOnSuspendInterceptorsAction()));
            log.debug("runLockSafe ['{}'] -> suspended", (Object)state.getBusinessKey());
        } else if (status == ProcessStatus.FINISHED) {
            if (raisedError != null) {
                state = this.getExecutor().eval(state, Collections.singletonList(new FireOnFailureInterceptorsAction(raisedError.getErrorRef())));
                log.debug("runLockSafe ['{}'] -> failed with '{}'", new Object[]{state.getBusinessKey(), raisedError.getErrorRef(), raisedError.getCause()});
                AbstractEngine.handleRaisedError(this.getConfiguration(), state, raisedError);
            } else {
                state = this.getExecutor().eval(state, Collections.singletonList(new FireOnFinishInterceptorsAction()));
                log.debug("runLockSafe ['{}'] -> done", (Object)state.getBusinessKey());
            }
        }
        if (log.isTraceEnabled()) {
            StateHelper.dump(state);
        }
    }

    private static void handleRaisedError(Configuration cfg, ProcessInstance state, BpmnError error) throws ExecutionException {
        switch (cfg.getUnhandledBpmnErrorStrategy()) {
            case EXCEPTION: 
            case PROPAGATE: {
                throw new ExecutionException("Unhandled BPMN error: " + error.getErrorRef(), (Throwable)error);
            }
            case IGNORE: {
                log.warn("handleRaisedError ['{}', '{}'] -> unhandled BPMN error", (Object)state.getBusinessKey(), (Object)error.getErrorRef());
            }
        }
    }

    private static ProcessInstance pushEventCommands(ProcessInstance state, Event ev) {
        Events events = state.getEvents();
        state = events.pushCommands(state, ev.getScopeId(), ev.getId());
        events = ev.isExclusive() ? events.clearScope(ev.getScopeId()) : events.removeEvent(ev.getScopeId(), ev.getId());
        return state.setEvents(events);
    }
}

