/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm;

import io.takari.bpm.IndexedProcessDefinition;
import io.takari.bpm.api.ExecutionException;
import io.takari.bpm.commands.Command;
import io.takari.bpm.commands.ProcessElementCommand;
import io.takari.bpm.misc.CoverageIgnore;
import io.takari.bpm.model.AbstractElement;
import io.takari.bpm.model.BoundaryEvent;
import io.takari.bpm.model.EndEvent;
import io.takari.bpm.model.EventBasedGateway;
import io.takari.bpm.model.IntermediateCatchEvent;
import io.takari.bpm.model.ParallelGateway;
import io.takari.bpm.model.ProcessDefinition;
import io.takari.bpm.model.SequenceFlow;
import io.takari.bpm.model.StartEvent;
import io.takari.bpm.model.SubProcess;
import io.takari.bpm.state.Activations;
import io.takari.bpm.state.ProcessInstance;
import io.takari.bpm.state.Scopes;
import io.takari.bpm.utils.Timeout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import org.joda.time.Duration;

public final class ProcessDefinitionUtils {
    public static ProcessDefinition findElementProcess(ProcessDefinition pd, String id) throws ExecutionException {
        ProcessDefinition sub = ProcessDefinitionUtils.findElementProcess0(pd, id);
        if (sub == null) {
            throw new ExecutionException("Invalid process definition '%s': unknown element '%s'", new Object[]{pd.getId(), id});
        }
        return sub;
    }

    private static ProcessDefinition findElementProcess0(ProcessDefinition pd, String id) {
        if (pd.hasChild(id)) {
            return pd;
        }
        for (AbstractElement e : pd.getChildren()) {
            ProcessDefinition sub;
            if (!(e instanceof ProcessDefinition) || (sub = ProcessDefinitionUtils.findElementProcess0((ProcessDefinition)e, id)) == null) continue;
            return sub;
        }
        return null;
    }

    public static AbstractElement findElement(ProcessDefinition pd, String id) throws ExecutionException {
        ProcessDefinition sub = ProcessDefinitionUtils.findElementProcess(pd, id);
        return sub.getChild(id);
    }

    public static SubProcess findSubProcess(ProcessDefinition pd, String id) throws ExecutionException {
        AbstractElement e = ProcessDefinitionUtils.findElement(pd, id);
        if (e instanceof SubProcess) {
            return (SubProcess)e;
        }
        throw new ExecutionException("Invalid process definition '%s': element '%s' is not a subprocess element", new Object[]{pd.getId(), id});
    }

    public static List<SequenceFlow> findOptionalOutgoingFlows(IndexedProcessDefinition pd, String from) throws ExecutionException {
        return pd.findOptionalOutgoingFlows(from);
    }

    public static List<SequenceFlow> findOutgoingFlows(IndexedProcessDefinition pd, String from) throws ExecutionException {
        List<SequenceFlow> result = ProcessDefinitionUtils.findOptionalOutgoingFlows(pd, from);
        if (result.isEmpty()) {
            throw new ExecutionException("Invalid process definition '%s': no flows from '%s'", new Object[]{pd.getId(), from});
        }
        return result;
    }

    public static SequenceFlow findOutgoingFlow(IndexedProcessDefinition pd, String from) throws ExecutionException {
        List<SequenceFlow> l = ProcessDefinitionUtils.findOutgoingFlows(pd, from);
        if (l.size() != 1) {
            throw new ExecutionException("Invalid process definition '%s': expected single flow from '%s'", new Object[]{pd.getId(), from});
        }
        return l.get(0);
    }

    public static SequenceFlow findAnyOutgoingFlow(IndexedProcessDefinition pd, String from) throws ExecutionException {
        List<SequenceFlow> l = ProcessDefinitionUtils.findOutgoingFlows(pd, from);
        return l.get(0);
    }

    public static List<SequenceFlow> findIncomingFlows(ProcessDefinition pd, String to) throws ExecutionException {
        ArrayList<SequenceFlow> result = new ArrayList<SequenceFlow>();
        ProcessDefinition sub = ProcessDefinitionUtils.findElementProcess(pd, to);
        for (AbstractElement e : sub.getChildren()) {
            SequenceFlow f;
            if (!(e instanceof SequenceFlow) || !to.equals((f = (SequenceFlow)e).getTo())) continue;
            result.add(f);
        }
        if (result.isEmpty()) {
            throw new ExecutionException("Invalid process definition '%s': no flows to '%s'", new Object[]{pd.getId(), to});
        }
        return result;
    }

    public static StartEvent findStartEvent(ProcessDefinition pd) throws ExecutionException {
        for (AbstractElement e : pd.getChildren()) {
            if (!(e instanceof StartEvent)) continue;
            return (StartEvent)e;
        }
        throw new ExecutionException("Invalid process definition '%s': no start event defined", new Object[]{pd.getId()});
    }

    public static List<BoundaryEvent> findOptionalBoundaryEvents(IndexedProcessDefinition pd, String attachedToRef) throws ExecutionException {
        List<BoundaryEvent> l = pd.findOptionalBoundaryEvents(attachedToRef);
        return l != null ? l : Collections.emptyList();
    }

    public static BoundaryEvent findBoundaryErrorEvent(IndexedProcessDefinition pd, String attachedToRef, String errorRef) throws ExecutionException {
        List<BoundaryEvent> l = ProcessDefinitionUtils.findOptionalBoundaryEvents(pd, attachedToRef);
        for (BoundaryEvent ev : l) {
            if (!attachedToRef.equals(ev.getAttachedToRef()) || !(errorRef != null ? errorRef.equals(ev.getErrorRef()) : ev.getErrorRef() == null && ev.getTimeDuration() == null)) continue;
            return ev;
        }
        return null;
    }

    private static void fillQueue(Queue<FlowSignal> q, IndexedProcessDefinition pd, String elemId, int count) throws ExecutionException {
        ProcessDefinitionUtils.findOptionalOutgoingFlows(pd, elemId).stream().map(s -> new FlowSignal((SequenceFlow)s, count)).forEach(q::add);
        for (BoundaryEvent be : ProcessDefinitionUtils.findOptionalBoundaryEvents(pd, elemId)) {
            ProcessDefinitionUtils.findOptionalOutgoingFlows(pd, be.getId()).stream().map(s -> new FlowSignal((SequenceFlow)s, 0)).forEach(q::add);
        }
    }

    private static List<FlowSignal> findDownstreamGatewayFlows(IndexedProcessDefinition pd, String from, int count) throws ExecutionException {
        HashSet<String> memento = new HashSet<String>();
        LinkedList<FlowSignal> processingQueue = new LinkedList<FlowSignal>();
        ArrayList<FlowSignal> results = new ArrayList<FlowSignal>();
        AbstractElement elem = ProcessDefinitionUtils.findElement(pd, from);
        if (elem instanceof SequenceFlow) {
            processingQueue.add(new FlowSignal((SequenceFlow)elem, count));
        } else {
            ProcessDefinitionUtils.fillQueue(processingQueue, pd, elem.getId(), count);
        }
        while (!processingQueue.isEmpty()) {
            AbstractElement target;
            FlowSignal fs = (FlowSignal)processingQueue.poll();
            if (!memento.add(fs.flow.getId()) || (target = ProcessDefinitionUtils.findElement(pd, fs.flow.getTo())) instanceof EndEvent) continue;
            if (ProcessDefinitionUtils.isParallelGateway(target)) {
                results.add(fs);
                continue;
            }
            ProcessDefinitionUtils.fillQueue(processingQueue, pd, target.getId(), fs.count);
        }
        return results;
    }

    public static boolean isParallelGateway(AbstractElement e) {
        return e instanceof ParallelGateway;
    }

    public static ProcessInstance activateGatewayFlow(ProcessInstance state, IndexedProcessDefinition pd, String elementId, int count) throws ExecutionException {
        Activations acts = state.getActivations();
        Scopes scopes = state.getScopes();
        UUID scopeId = scopes.getCurrentId();
        for (FlowSignal fs : ProcessDefinitionUtils.findDownstreamGatewayFlows(pd, elementId, count)) {
            acts = acts.incExpectation(scopes, scopeId, fs.flow.getId(), fs.count);
        }
        return state.setActivations(acts);
    }

    public static boolean isTracedToElement(IndexedProcessDefinition pd, String flowId, String elementId) throws ExecutionException {
        HashSet<String> memento = new HashSet<String>();
        LinkedList<String> processingQueue = new LinkedList<String>();
        processingQueue.add(flowId);
        while (!processingQueue.isEmpty()) {
            String nextId = (String)processingQueue.poll();
            if (nextId.equals(elementId)) {
                return true;
            }
            if (!memento.add(nextId)) continue;
            AbstractElement target = ProcessDefinitionUtils.findElement(pd, nextId);
            if (target instanceof SequenceFlow) {
                processingQueue.add(((SequenceFlow)target).getTo());
                continue;
            }
            ProcessDefinitionUtils.findOptionalOutgoingFlows(pd, nextId).stream().forEach(f -> {
                boolean bl = processingQueue.add(f.getId());
            });
        }
        return false;
    }

    public static List<String> toIds(List<? extends AbstractElement> elements) {
        ArrayList<String> result = new ArrayList<String>(elements.size());
        for (AbstractElement abstractElement : elements) {
            result.add(abstractElement.getId());
        }
        return result;
    }

    private static EventBasedGateway findEventGateway(ProcessDefinition pd, String eventElementId) throws ExecutionException {
        for (SequenceFlow flow : ProcessDefinitionUtils.findIncomingFlows(pd, eventElementId)) {
            AbstractElement elem = ProcessDefinitionUtils.findElement(pd, flow.getFrom());
            if (!(elem instanceof EventBasedGateway)) continue;
            return (EventBasedGateway)elem;
        }
        return null;
    }

    public static List<IntermediateCatchEvent> findSiblingEvents(IndexedProcessDefinition pd, String eventElementId) throws ExecutionException {
        EventBasedGateway gate = ProcessDefinitionUtils.findEventGateway(pd, eventElementId);
        ArrayList<IntermediateCatchEvent> events = new ArrayList<IntermediateCatchEvent>();
        if (gate != null) {
            for (SequenceFlow flow : ProcessDefinitionUtils.findOutgoingFlows(pd, gate.getId())) {
                AbstractElement elem = ProcessDefinitionUtils.findElement(pd, flow.getTo());
                if (!(elem instanceof IntermediateCatchEvent)) continue;
                events.add((IntermediateCatchEvent)elem);
            }
        }
        return events;
    }

    public static List<SequenceFlow> findFlows(ProcessDefinition pd, List<String> ids) throws ExecutionException {
        ArrayList<SequenceFlow> result = new ArrayList<SequenceFlow>();
        for (String id : ids) {
            SequenceFlow f = (SequenceFlow)ProcessDefinitionUtils.findElement(pd, id);
            result.add(f);
        }
        return result;
    }

    public static List<Timeout<Command>> findTimers(IndexedProcessDefinition pd, ProcessElementCommand cmd) throws ExecutionException {
        List<BoundaryEvent> events = ProcessDefinitionUtils.findOptionalBoundaryEvents(pd, cmd.getElementId());
        ArrayList<Timeout<Command>> l = new ArrayList<Timeout<Command>>(events.size());
        for (BoundaryEvent ev : events) {
            if (ev.getTimeDuration() == null) continue;
            Duration d = Duration.parse((String)ev.getTimeDuration());
            ProcessElementCommand c = new ProcessElementCommand(pd.getId(), ev.getId());
            l.add(new Timeout<ProcessElementCommand>(d.getMillis(), c));
        }
        l.sort((o1, o2) -> (int)(o1.getDuration() - o2.getDuration()));
        return l;
    }

    public static Command findDefaultError(IndexedProcessDefinition pd, ProcessElementCommand cmd) throws ExecutionException {
        List<BoundaryEvent> events = ProcessDefinitionUtils.findOptionalBoundaryEvents(pd, cmd.getElementId());
        for (BoundaryEvent ev : events) {
            if (ev.getErrorRef() != null || ev.getTimeDuration() != null) continue;
            return new ProcessElementCommand(pd.getId(), ev.getId());
        }
        return null;
    }

    public static Map<String, Command> findErrors(IndexedProcessDefinition pd, ProcessElementCommand cmd) throws ExecutionException {
        HashMap<String, Command> m = new HashMap<String, Command>();
        List<BoundaryEvent> events = ProcessDefinitionUtils.findOptionalBoundaryEvents(pd, cmd.getElementId());
        for (BoundaryEvent ev : events) {
            if (ev.getErrorRef() == null || ev.getTimeDuration() != null) continue;
            m.put(ev.getErrorRef(), new ProcessElementCommand(pd.getId(), ev.getId()));
        }
        return m;
    }

    @CoverageIgnore
    private ProcessDefinitionUtils() {
    }

    private static class FlowSignal {
        final SequenceFlow flow;
        final int count;

        public FlowSignal(SequenceFlow flow, int count) {
            this.flow = flow;
            this.count = count;
        }
    }
}

