/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.context;

import io.takari.bpm.actions.CreateEventAction;
import io.takari.bpm.commands.Command;
import io.takari.bpm.commands.CommandStack;
import io.takari.bpm.commands.PerformActionsCommand;
import io.takari.bpm.context.ExecutionContextImpl;
import io.takari.bpm.state.ProcessInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContextUtils {
    private static final Logger log = LoggerFactory.getLogger(ContextUtils.class);

    public static ProcessInstance handleSuspend(ProcessInstance state, ExecutionContextImpl ctx, String definitionId, String elementId, Command nextCommand) {
        CommandStack stack = state.getStack();
        String messageRef = ctx.getSuspendMessageRef();
        if (messageRef == null) {
            log.debug("handleSuspend ['{}'] -> next action is '{}'", (Object)state.getBusinessKey(), (Object)nextCommand);
            stack = stack.push(nextCommand);
        } else {
            log.debug("handleSuspend ['{}'] -> suspend is requested '{}'", (Object)state.getBusinessKey(), (Object)messageRef);
            stack = stack.push(new PerformActionsCommand(new CreateEventAction(definitionId, elementId, messageRef, null, null, null, ctx.getSuspendPayload(), ctx.isResumeFromSameStep(), ctx.changes())));
        }
        return state.setStack(stack);
    }

    private ContextUtils() {
    }
}

