/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.context;

import io.takari.bpm.api.ExecutionContext;
import io.takari.bpm.api.ExecutionContextFactory;
import io.takari.bpm.api.Variables;
import io.takari.bpm.context.ExecutionContextImpl;
import io.takari.bpm.el.ExpressionManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class DefaultExecutionContextFactory
implements ExecutionContextFactory<ExecutionContextImpl> {
    private final ExpressionManager expressionManager;

    public DefaultExecutionContextFactory(ExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
    }

    public ExecutionContextImpl create(Variables source) {
        return new ExecutionContextImpl(this, this.expressionManager, source);
    }

    public ExecutionContextImpl create(Variables source, String processDefinitionId, String elementId) {
        return new ExecutionContextImpl(this, this.expressionManager, source, processDefinitionId, elementId);
    }

    public ExecutionContext withOverrides(ExecutionContext delegate, Map<Object, Object> overrides) {
        return new MapBackedExecutionContext(this, this.expressionManager, delegate, overrides);
    }

    public static class MapBackedExecutionContext
    implements ExecutionContext {
        private final ExecutionContextFactory<? extends ExecutionContext> executionContextFactory;
        private final ExpressionManager exprManager;
        private final ExecutionContext delegate;
        private final Map<Object, Object> overrides;

        public MapBackedExecutionContext(ExecutionContextFactory<? extends ExecutionContext> executionContextFactory, ExpressionManager exprManager, ExecutionContext delegate, Map<Object, Object> overrides) {
            this.executionContextFactory = executionContextFactory;
            this.exprManager = exprManager;
            this.delegate = delegate;
            this.overrides = overrides;
        }

        public Object getVariable(String key) {
            if (this.overrides.containsKey(key)) {
                return this.overrides.get(key);
            }
            return this.delegate.getVariable(key);
        }

        public Map<String, Object> getVariables() {
            throw new IllegalStateException("Not supported");
        }

        public void setVariable(String key, Object value) {
            throw new IllegalStateException("Not supported");
        }

        public boolean hasVariable(String key) {
            return this.overrides.containsKey(key) || this.delegate.hasVariable(key);
        }

        public void removeVariable(String key) {
            throw new IllegalStateException("Not supported");
        }

        public Set<String> getVariableNames() {
            HashSet<String> result = new HashSet<String>(this.delegate.getVariableNames());
            result.addAll(this.overrides.keySet().stream().filter(k -> k instanceof String).map(k -> (String)k).collect(Collectors.toSet()));
            return result;
        }

        public <T> T eval(String expr, Class<T> type) {
            return this.exprManager.eval(this, expr, type);
        }

        public Map<String, Object> toMap() {
            HashMap<String, Object> result = new HashMap<String, Object>(this.delegate.toMap());
            for (Map.Entry<Object, Object> e : this.overrides.entrySet()) {
                if (!(e.getKey() instanceof String)) continue;
                result.put((String)e.getKey(), e.getValue());
            }
            return result;
        }

        public Object interpolate(Object v) {
            return this.exprManager.interpolate(this.executionContextFactory, this, v);
        }

        public void suspend(String messageRef) {
            throw new IllegalStateException("Not supported");
        }

        public void suspend(String messageRef, Object payload, boolean resumeFromSameStep) {
            throw new IllegalStateException("Not supported");
        }

        public String getProcessDefinitionId() {
            return this.delegate.getProcessDefinitionId();
        }

        public String getElementId() {
            return this.delegate.getElementId();
        }
    }
}

