/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.el;

import io.takari.bpm.api.ExecutionContext;
import io.takari.bpm.el.ExpressionManager;
import io.takari.bpm.task.KeyAwareServiceTaskRegistry;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptingExpressionManager
implements ExpressionManager {
    private static final Logger log = LoggerFactory.getLogger(ScriptingExpressionManager.class);
    private final ThreadLocal<ScriptEngine> engine = ThreadLocal.withInitial(() -> new ScriptEngineManager().getEngineByName(engineName));
    private final KeyAwareServiceTaskRegistry taskRegistry;

    public ScriptingExpressionManager(String engineName, KeyAwareServiceTaskRegistry taskRegistry) {
        this.taskRegistry = taskRegistry;
    }

    @Override
    public <T> T eval(ExecutionContext ctx, String expr, Class<T> type) {
        try {
            ScriptEngine e = this.engine.get();
            CustomBindings b = new CustomBindings(this.taskRegistry, ctx);
            return type.cast(e.eval(expr, (Bindings)b));
        }
        catch (Exception e) {
            log.error("eval ['{}'] -> error", (Object)expr, (Object)e);
            throw new RuntimeException(e);
        }
    }

    public static class CustomBindings
    extends SimpleBindings {
        private static final String CONTEXT_KEY = "execution";
        private final KeyAwareServiceTaskRegistry taskRegistry;
        private final ExecutionContext ctx;

        public CustomBindings(KeyAwareServiceTaskRegistry taskRegistry, ExecutionContext ctx) {
            this.taskRegistry = taskRegistry;
            this.ctx = ctx;
            this.put(CONTEXT_KEY, (Object)ctx);
        }

        @Override
        public Object get(Object key) {
            if (super.containsKey(key)) {
                return super.get(key);
            }
            Object res = this.ctx.getVariable((String)key);
            if (res != null) {
                return res;
            }
            return this.taskRegistry.getByKey((String)key);
        }

        @Override
        public boolean containsKey(Object key) {
            return super.containsKey(key) || this.ctx.hasVariable((String)key) || this.taskRegistry.containsKey((String)key);
        }
    }
}

