/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.elements;

import io.takari.bpm.IndexedProcessDefinition;
import io.takari.bpm.ProcessDefinitionUtils;
import io.takari.bpm.actions.Action;
import io.takari.bpm.actions.MakeSubProcessVariablesAction;
import io.takari.bpm.actions.PopCommandAction;
import io.takari.bpm.actions.PushCommandAction;
import io.takari.bpm.actions.PushScopeAction;
import io.takari.bpm.api.ExecutionException;
import io.takari.bpm.commands.ActivityFinalizerCommand;
import io.takari.bpm.commands.Command;
import io.takari.bpm.commands.MergeVariablesCommand;
import io.takari.bpm.commands.PerformActionsCommand;
import io.takari.bpm.commands.ProcessElementCommand;
import io.takari.bpm.elements.ElementHandler;
import io.takari.bpm.model.ProcessDefinition;
import io.takari.bpm.model.StartEvent;
import io.takari.bpm.model.SubProcess;
import io.takari.bpm.model.VariableMapping;
import io.takari.bpm.state.ProcessInstance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class SubProcessHandler
implements ElementHandler {
    @Override
    public List<Action> handle(ProcessInstance state, ProcessElementCommand cmd, List<Action> actions) throws ExecutionException {
        actions.add(new PopCommandAction());
        IndexedProcessDefinition pd = state.getDefinition(cmd.getDefinitionId());
        SubProcess s = (SubProcess)ProcessDefinitionUtils.findElement(pd, cmd.getElementId());
        ActivityFinalizerCommand errorHandlingCmd = new ActivityFinalizerCommand(cmd.getDefinitionId(), cmd.getElementId());
        actions.add(new PushCommandAction(errorHandlingCmd));
        ArrayList<Command> finishers = new ArrayList<Command>();
        finishers.add(errorHandlingCmd);
        if (s.isUseSeparateContext()) {
            actions.add(new MakeSubProcessVariablesAction(true));
            Set<VariableMapping> outVariables = s.getOutVariables();
            if (outVariables == null) {
                outVariables = Collections.emptySet();
            }
            MergeVariablesCommand mergeCommand = new MergeVariablesCommand(state.getVariables(), outVariables);
            actions.add(new PushCommandAction(mergeCommand));
            finishers.add(mergeCommand);
        }
        SubProcess sub = ProcessDefinitionUtils.findSubProcess(pd, cmd.getElementId());
        StartEvent start = ProcessDefinitionUtils.findStartEvent((ProcessDefinition)sub);
        ProcessElementCommand startCmd = new ProcessElementCommand(cmd.getDefinitionId(), start.getId());
        actions.add(new PushCommandAction(startCmd));
        actions.add(new PushCommandAction(new PerformActionsCommand(new PushScopeAction(cmd.getDefinitionId(), cmd.getElementId(), false, finishers.toArray(new Command[finishers.size()])))));
        return actions;
    }
}

