/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.form;

import io.takari.bpm.api.Engine;
import io.takari.bpm.api.ExecutionContext;
import io.takari.bpm.api.ExecutionContextFactory;
import io.takari.bpm.api.ExecutionException;
import io.takari.bpm.api.Variables;
import io.takari.bpm.form.DefaultFormValidator;
import io.takari.bpm.form.Form;
import io.takari.bpm.form.FormService;
import io.takari.bpm.form.FormStorage;
import io.takari.bpm.form.FormSubmitResult;
import io.takari.bpm.form.FormValidator;
import io.takari.bpm.misc.CoverageIgnore;
import io.takari.bpm.model.form.FormDefinition;
import io.takari.bpm.model.form.FormField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class DefaultFormService
implements FormService {
    private final ExecutionContextFactory contextFactory;
    private final ResumeHandler resumeHandler;
    private final FormStorage formStorage;
    private final FormValidator validator;

    public DefaultFormService(ExecutionContextFactory contextFactory, ResumeHandler resumeHandler, FormStorage formStorage) {
        this(contextFactory, resumeHandler, formStorage, new DefaultFormValidator());
    }

    public DefaultFormService(ExecutionContextFactory contextFactory, ResumeHandler resumeHandler, FormStorage formStorage, FormValidator validator) {
        this.contextFactory = contextFactory;
        this.resumeHandler = resumeHandler;
        this.formStorage = formStorage;
        this.validator = validator;
    }

    @Override
    public void create(String processBusinessKey, UUID formInstanceId, String eventName, FormDefinition formDefinition, Map<String, Object> options, Map<String, Object> env) throws ExecutionException {
        Form f = new Form(processBusinessKey, formInstanceId, eventName, formDefinition, env, Collections.emptyMap(), options);
        f = DefaultFormService.prepare(this.contextFactory, this.validator, f);
        this.formStorage.save(f);
    }

    @Override
    public Form get(UUID formInstanceId) throws ExecutionException {
        Form form = this.formStorage.get(formInstanceId);
        if (form == null) {
            throw new ExecutionException("Form not found: " + formInstanceId);
        }
        return this.formStorage.get(formInstanceId);
    }

    @Override
    public FormSubmitResult submit(UUID formInstanceId, Map<String, Object> data) throws ExecutionException {
        Form form = this.formStorage.get(formInstanceId);
        if (form == null) {
            throw new ExecutionException("Form not found: " + formInstanceId);
        }
        FormSubmitResult result = DefaultFormService.submit(this.resumeHandler, this.validator, form, data);
        if (result.isValid()) {
            this.formStorage.complete(formInstanceId);
        }
        return result;
    }

    public static Form prepare(ExecutionContextFactory contextFactory, FormValidator validator, Form form) throws ExecutionException {
        FormDefinition fd;
        String formName;
        Map<String, Object> env = form.getEnv();
        env = new LinkedHashMap<String, Object>(env != null ? env : Collections.emptyMap());
        Map defaults = (Map)env.get(formName = (fd = form.getFormDefinition()).getName());
        if (defaults == null) {
            defaults = Collections.emptyMap();
        }
        LinkedHashMap values = new LinkedHashMap(defaults);
        Map<String, Object> allowedValues = form.getAllowedValues();
        allowedValues = new LinkedHashMap<String, Object>(allowedValues != null ? allowedValues : Collections.emptyMap());
        ArrayList<FormField> formFields = new ArrayList<FormField>();
        for (FormField f : fd.getFields()) {
            Variables vars;
            ExecutionContext ctx;
            Object allowedValue;
            String k = f.getName();
            Object v = defaults.get(k);
            Object defaultValue = f.getDefaultValue();
            if (defaultValue != null) {
                Variables vars2 = new Variables(env);
                ExecutionContext ctx2 = contextFactory.create(vars2);
                v = ctx2.interpolate(defaultValue);
            }
            if ((allowedValue = f.getAllowedValue()) != null && (allowedValue = (ctx = contextFactory.create(vars = new Variables(env))).interpolate(allowedValue)) != null) {
                allowedValues.put(f.getName(), allowedValue);
            }
            FormField ff = DefaultFormService.interpolateFormField(env, contextFactory, f);
            formFields.add(ff);
            if (v == null) continue;
            FormSubmitResult.ValidationError e = validator.validate(formName, f, v, allowedValue);
            if (e != null) {
                throw new ExecutionException("Got an incompatible default value '%s'. %s", new Object[]{v, e.getError()});
            }
            values.put(k, v);
        }
        env = new LinkedHashMap<String, Object>();
        env.put(formName, values);
        FormDefinition formDefinition = new FormDefinition(formName, formFields);
        Map<String, Object> options = form.getOptions();
        return new Form(form.getProcessBusinessKey(), form.getFormInstanceId(), form.getEventName(), formDefinition, env, allowedValues, options);
    }

    public static FormField interpolateFormField(Map<String, Object> env, ExecutionContextFactory contextFactory, FormField field) {
        Variables vars = new Variables(env);
        ExecutionContext ctx = contextFactory.create(vars);
        String label = (String)ctx.interpolate((Object)field.getLabel());
        FormField.Builder interpolatedField = new FormField.Builder(field).label(label);
        return interpolatedField.build();
    }

    public static FormSubmitResult submit(ResumeHandler resumeHandler, FormValidator validator, Form form, Map<String, Object> data) throws ExecutionException {
        String processBusinessKey = form.getProcessBusinessKey();
        List<FormSubmitResult.ValidationError> errors = validator.validate(form, data);
        if (errors != null && !errors.isEmpty()) {
            return new FormSubmitResult(processBusinessKey, errors);
        }
        FormDefinition fd = form.getFormDefinition();
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put(fd.getName(), new LinkedHashMap<String, Object>(data));
        resumeHandler.resume(form, args);
        return FormSubmitResult.ok(processBusinessKey);
    }

    public static class DirectResumeHandler
    implements ResumeHandler {
        private final Engine engine;

        public DirectResumeHandler(Engine engine) {
            this.engine = engine;
        }

        @Override
        public void resume(Form form, Map<String, Object> args) throws ExecutionException {
            this.engine.resume(form.getProcessBusinessKey(), form.getEventName(), args);
        }
    }

    public static class NoopResumeHandler
    implements ResumeHandler {
        @Override
        @CoverageIgnore
        public void resume(Form form, Map<String, Object> args) throws ExecutionException {
        }
    }

    public static interface ResumeHandler {
        public void resume(Form var1, Map<String, Object> var2) throws ExecutionException;
    }
}

