/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.form;

import io.takari.bpm.api.ExecutionException;
import io.takari.bpm.form.DefaultFormValidatorLocale;
import io.takari.bpm.form.Form;
import io.takari.bpm.form.FormSubmitResult;
import io.takari.bpm.form.FormValidator;
import io.takari.bpm.form.FormValidatorLocale;
import io.takari.bpm.model.form.DefaultFormFields;
import io.takari.bpm.model.form.FormDefinition;
import io.takari.bpm.model.form.FormField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultFormValidator
implements FormValidator {
    private final FormValidatorLocale locale;
    private final Collection<FieldValidator> validators;

    public DefaultFormValidator() {
        this(new DefaultFormValidatorLocale());
    }

    public DefaultFormValidator(FormValidatorLocale locale) {
        this.locale = locale;
        ArrayList<FieldValidator> vs = new ArrayList<FieldValidator>();
        vs.add(new StringFieldValidator(locale));
        vs.add(new IntegerFieldValidator(locale));
        vs.add(new DecimalFieldValidator(locale));
        vs.add(new BooleanFieldValidator(locale));
        this.validators = vs;
    }

    public DefaultFormValidator(Collection<FieldValidator> validators, FormValidatorLocale locale) {
        this.validators = validators;
        this.locale = locale;
    }

    @Override
    public List<FormSubmitResult.ValidationError> validate(Form form, Map<String, Object> data) throws ExecutionException {
        Map<String, Object> allowedValues;
        ArrayList<FormSubmitResult.ValidationError> errors = new ArrayList<FormSubmitResult.ValidationError>();
        FormDefinition fd = form.getFormDefinition();
        String formId = fd.getName();
        List fields = fd.getFields();
        if (fields == null || fields.isEmpty()) {
            errors.add(new FormSubmitResult.ValidationError("_global", this.locale.noFieldsDefined(formId)));
            return errors;
        }
        Map<String, Object> values = data;
        if (values == null) {
            values = Collections.emptyMap();
        }
        if ((allowedValues = form.getAllowedValues()) == null) {
            allowedValues = Collections.emptyMap();
        }
        for (FormField f : fields) {
            Object allowed;
            Object v;
            FormSubmitResult.ValidationError e = this.validate(formId, f, v = values.get(f.getName()), allowed = allowedValues.get(f.getName()));
            if (e == null) continue;
            errors.add(e);
        }
        return errors;
    }

    @Override
    public FormSubmitResult.ValidationError validate(String formId, FormField f, Object v, Object allowed) throws ExecutionException {
        String fieldName = f.getName();
        FormField.Cardinality expectedCardinality = f.getCardinality();
        if (expectedCardinality == null) {
            throw new ExecutionException("Field without a cardinality parameter: " + fieldName);
        }
        if (!DefaultFormValidator.checkCardinality(v, expectedCardinality)) {
            return new FormSubmitResult.ValidationError(fieldName, this.locale.invalidCardinality(formId, f, v));
        }
        if (v == null) {
            return null;
        }
        v = DefaultFormValidator.box(v);
        allowed = DefaultFormValidator.box(allowed);
        if (v instanceof Collection) {
            Collection vs = (Collection)v;
            int idx = 0;
            for (Object vv : vs) {
                FormSubmitResult.ValidationError e;
                if ((e = this.validateSingleValue(formId, f, idx++, vv, allowed)) == null) continue;
                return e;
            }
        } else if (v instanceof Object[]) {
            Object[] vs = (Object[])v;
            int i = 0;
            while (i < vs.length) {
                FormSubmitResult.ValidationError e = this.validateSingleValue(formId, f, i, vs[i], allowed);
                if (e != null) {
                    return e;
                }
                ++i;
            }
        } else {
            return this.validateSingleValue(formId, f, null, v, allowed);
        }
        return null;
    }

    private FormSubmitResult.ValidationError validateSingleValue(String formId, FormField f, Integer idx, Object v, Object allowed) throws ExecutionException {
        String type = f.getType();
        if (type == null) {
            throw new ExecutionException("Field '%s', unknown type", new Object[]{f.getName()});
        }
        String fieldName = f.getName();
        if (allowed != null && !DefaultFormValidator.checkAllowedValue(v, allowed)) {
            return new FormSubmitResult.ValidationError(fieldName, this.locale.valueNotAllowed(formId, f, idx, allowed, v));
        }
        boolean validated = false;
        for (FieldValidator validator : this.validators) {
            String[] stringArray = validator.allowedTypes();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String t = stringArray[n2];
                if (type.equals(t)) {
                    FormSubmitResult.ValidationError e = validator.validate(formId, f, idx, v);
                    if (e != null) {
                        return e;
                    }
                    validated = true;
                }
                ++n2;
            }
        }
        if (!validated) {
            throw new ExecutionException("Unsupported form field type: " + type);
        }
        return null;
    }

    private static boolean checkAllowedValue(Object v, Object allowed) {
        if (v.equals(allowed)) {
            return true;
        }
        if (allowed instanceof Collection) {
            Collection aa = (Collection)allowed;
            return aa.contains(v);
        }
        if (allowed instanceof Object[]) {
            Object[] as;
            Object[] objectArray = as = (Object[])allowed;
            int n = as.length;
            int n2 = 0;
            while (n2 < n) {
                Object aa = objectArray[n2];
                if (v.equals(aa)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private static boolean checkCardinality(Object v, FormField.Cardinality required) {
        Set<FormField.Cardinality> actual = DefaultFormValidator.guessCardinality(v);
        return actual.contains(required);
    }

    private static Set<FormField.Cardinality> guessCardinality(Object v) {
        int len = DefaultFormValidator.length(v);
        if (len < 0) {
            throw new IllegalArgumentException("Can't determine object's length: " + v);
        }
        if (len == 0) {
            return DefaultFormValidator.set(FormField.Cardinality.ANY, FormField.Cardinality.ONE_OR_NONE);
        }
        if (len == 1) {
            return DefaultFormValidator.set(FormField.Cardinality.ANY, FormField.Cardinality.ONE_OR_NONE, FormField.Cardinality.ONE_AND_ONLY_ONE, FormField.Cardinality.AT_LEAST_ONE);
        }
        return DefaultFormValidator.set(FormField.Cardinality.ANY, FormField.Cardinality.AT_LEAST_ONE);
    }

    private static Set<FormField.Cardinality> set(FormField.Cardinality ... values) {
        HashSet<FormField.Cardinality> s = new HashSet<FormField.Cardinality>(values.length);
        FormField.Cardinality[] cardinalityArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            FormField.Cardinality v = cardinalityArray[n2];
            s.add(v);
            ++n2;
        }
        return s;
    }

    private static int length(Object v) {
        if (v == null) {
            return 0;
        }
        if (v instanceof Collection) {
            return ((Collection)v).size();
        }
        if (v instanceof Object[]) {
            Object[] arr = (Object[])v;
            return arr.length;
        }
        return 1;
    }

    private static boolean withinBounds(Object v, Long min, Long max) {
        if (min == null && max == null) {
            return true;
        }
        boolean low = true;
        boolean high = true;
        if (v instanceof Long) {
            Long l = (Long)v;
            if (min != null) {
                boolean bl = low = l >= min;
            }
            if (max != null) {
                high = l <= max;
            }
        } else if (v instanceof Integer) {
            Integer i = (Integer)v;
            if (min != null) {
                if (!DefaultFormValidator.validInt(min)) {
                    throw new IllegalArgumentException("Invalid integer min bound: " + min + ", use long values if needed");
                }
                boolean bl = low = i >= min.intValue();
            }
            if (max != null) {
                if (!DefaultFormValidator.validInt(max)) {
                    throw new IllegalArgumentException("Invalid integer max bound: " + max + ", use long values if needed");
                }
                high = i <= max.intValue();
            }
        } else {
            throw new IllegalArgumentException("Unsupported integer type: " + v.getClass());
        }
        return low && high;
    }

    private static boolean withinBounds(Object v, Double min, Double max) {
        if (min == null && max == null) {
            return true;
        }
        boolean low = true;
        boolean high = true;
        if (v instanceof Double) {
            Double l = (Double)v;
            if (min != null) {
                boolean bl = low = l >= min;
            }
            if (max != null) {
                high = l <= max;
            }
        } else if (v instanceof Float) {
            Float i = (Float)v;
            if (min != null) {
                if (!DefaultFormValidator.validFloat(min)) {
                    throw new IllegalArgumentException("Invalid float min bound: " + min + ", use double values if needed");
                }
                boolean bl = low = i.floatValue() >= min.floatValue();
            }
            if (max != null) {
                if (!DefaultFormValidator.validFloat(max)) {
                    throw new IllegalArgumentException("Invalid float max bound: " + max + ", use double values if needed");
                }
                high = i.floatValue() <= max.floatValue();
            }
        } else {
            throw new IllegalArgumentException("Unsupported decimal type: " + v.getClass());
        }
        return low && high;
    }

    private static boolean validInt(Long l) {
        return l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE;
    }

    private static boolean validFloat(Double d) {
        return d <= 3.4028234663852886E38 && d >= (double)1.4E-45f;
    }

    private static Object box(Object v) {
        if (v == null) {
            return null;
        }
        if (v instanceof int[]) {
            int[] is = (int[])v;
            Object[] os = new Object[is.length];
            int i = 0;
            while (i < is.length) {
                os[i] = is[i];
                ++i;
            }
            return os;
        }
        if (v instanceof long[]) {
            long[] is = (long[])v;
            Object[] os = new Object[is.length];
            int i = 0;
            while (i < is.length) {
                os[i] = is[i];
                ++i;
            }
            return os;
        }
        if (v instanceof float[]) {
            float[] is = (float[])v;
            Object[] os = new Object[is.length];
            int i = 0;
            while (i < is.length) {
                os[i] = Float.valueOf(is[i]);
                ++i;
            }
            return os;
        }
        if (v instanceof double[]) {
            double[] is = (double[])v;
            Object[] os = new Object[is.length];
            int i = 0;
            while (i < is.length) {
                os[i] = is[i];
                ++i;
            }
            return os;
        }
        if (v instanceof boolean[]) {
            boolean[] is = (boolean[])v;
            Object[] os = new Object[is.length];
            int i = 0;
            while (i < is.length) {
                os[i] = is[i];
                ++i;
            }
            return os;
        }
        if (v instanceof char[]) {
            char[] is = (char[])v;
            Object[] os = new Object[is.length];
            int i = 0;
            while (i < is.length) {
                os[i] = Character.valueOf(is[i]);
                ++i;
            }
            return os;
        }
        return v;
    }

    public static final class BooleanFieldValidator
    implements FieldValidator {
        private static final String[] TYPES = new String[]{"boolean"};
        private final FormValidatorLocale locale;

        public BooleanFieldValidator(FormValidatorLocale locale) {
            this.locale = locale;
        }

        @Override
        public String[] allowedTypes() {
            return TYPES;
        }

        @Override
        public FormSubmitResult.ValidationError validate(String formId, FormField f, Integer idx, Object v) throws ExecutionException {
            String fieldName = f.getName();
            if (!(v instanceof Boolean)) {
                return new FormSubmitResult.ValidationError(fieldName, this.locale.expectedBoolean(formId, f, idx, v));
            }
            return null;
        }
    }

    public static final class DecimalFieldValidator
    implements FieldValidator {
        private static final String[] TYPES = new String[]{"decimal"};
        private final FormValidatorLocale locale;

        public DecimalFieldValidator(FormValidatorLocale locale) {
            this.locale = locale;
        }

        @Override
        public String[] allowedTypes() {
            return TYPES;
        }

        @Override
        public FormSubmitResult.ValidationError validate(String formId, FormField f, Integer idx, Object v) throws ExecutionException {
            String fieldName = f.getName();
            if (v instanceof Double || v instanceof Float) {
                Double max;
                Double min = (Double)f.getOption(DefaultFormFields.DecimalField.MIN);
                if (!DefaultFormValidator.withinBounds(v, min, max = (Double)f.getOption(DefaultFormFields.DecimalField.MAX))) {
                    return new FormSubmitResult.ValidationError(fieldName, this.locale.decimalRangeError(formId, f, idx, min, max, v));
                }
            } else {
                return new FormSubmitResult.ValidationError(fieldName, this.locale.expectedDecimal(formId, f, idx, v));
            }
            return null;
        }
    }

    public static interface FieldValidator {
        public String[] allowedTypes();

        public FormSubmitResult.ValidationError validate(String var1, FormField var2, Integer var3, Object var4) throws ExecutionException;
    }

    public static final class IntegerFieldValidator
    implements FieldValidator {
        private static final String[] TYPES = new String[]{"int"};
        private final FormValidatorLocale locale;

        public IntegerFieldValidator(FormValidatorLocale locale) {
            this.locale = locale;
        }

        @Override
        public String[] allowedTypes() {
            return TYPES;
        }

        @Override
        public FormSubmitResult.ValidationError validate(String formId, FormField f, Integer idx, Object v) throws ExecutionException {
            String fieldName = f.getName();
            if (v instanceof Integer || v instanceof Long) {
                Long max;
                Long min = (Long)f.getOption(DefaultFormFields.IntegerField.MIN);
                if (!DefaultFormValidator.withinBounds(v, min, max = (Long)f.getOption(DefaultFormFields.IntegerField.MAX))) {
                    return new FormSubmitResult.ValidationError(fieldName, this.locale.integerRangeError(formId, f, idx, min, max, v));
                }
            } else {
                return new FormSubmitResult.ValidationError(fieldName, this.locale.expectedInteger(formId, f, idx, v));
            }
            return null;
        }
    }

    public static final class StringFieldValidator
    implements FieldValidator {
        private static final String[] TYPES = new String[]{"string"};
        private final FormValidatorLocale locale;

        public StringFieldValidator(FormValidatorLocale locale) {
            this.locale = locale;
        }

        @Override
        public String[] allowedTypes() {
            return TYPES;
        }

        @Override
        public FormSubmitResult.ValidationError validate(String formId, FormField f, Integer idx, Object v) throws ExecutionException {
            String fieldName = f.getName();
            if (v instanceof String) {
                String pattern = (String)f.getOption(DefaultFormFields.StringField.PATTERN);
                if (pattern == null) {
                    return null;
                }
                String sv = (String)v;
                if (!sv.matches(pattern)) {
                    return new FormSubmitResult.ValidationError(fieldName, this.locale.doesntMatchPattern(formId, f, idx, pattern, v));
                }
            } else {
                return new FormSubmitResult.ValidationError(fieldName, this.locale.expectedString(formId, f, idx, v));
            }
            return null;
        }
    }
}

