/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.planner;

import io.takari.bpm.Configuration;
import io.takari.bpm.IndexedProcessDefinition;
import io.takari.bpm.ProcessDefinitionUtils;
import io.takari.bpm.actions.Action;
import io.takari.bpm.actions.ActivateElementAction;
import io.takari.bpm.actions.ActivateFlowsAction;
import io.takari.bpm.actions.FollowFlowsAction;
import io.takari.bpm.actions.PopCommandAction;
import io.takari.bpm.actions.PopScopeAction;
import io.takari.bpm.actions.PushCommandAction;
import io.takari.bpm.actions.SetVariableAction;
import io.takari.bpm.api.BpmnError;
import io.takari.bpm.api.ExecutionException;
import io.takari.bpm.commands.ActivityFinalizerCommand;
import io.takari.bpm.commands.PerformActionsCommand;
import io.takari.bpm.model.BoundaryEvent;
import io.takari.bpm.model.SequenceFlow;
import io.takari.bpm.planner.CommandHandler;
import io.takari.bpm.state.BpmnErrorHelper;
import io.takari.bpm.state.Events;
import io.takari.bpm.state.ProcessInstance;
import io.takari.bpm.state.Scopes;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityFinalizerCommandHandler
implements CommandHandler<ActivityFinalizerCommand> {
    private static final Logger log = LoggerFactory.getLogger(ActivityFinalizerCommandHandler.class);
    private final Configuration cfg;

    public ActivityFinalizerCommandHandler(Configuration cfg) {
        this.cfg = cfg;
    }

    @Override
    public List<Action> handle(ProcessInstance state, ActivityFinalizerCommand cmd, List<Action> actions) throws ExecutionException {
        actions.add(new PopCommandAction());
        Scopes scopes = state.getScopes();
        Events events = state.getEvents();
        if (!events.isEmpty(scopes, scopes.getCurrentId())) {
            actions.add(new PushCommandAction(new PerformActionsCommand(new PopScopeAction())));
            return actions;
        }
        BpmnError error = BpmnErrorHelper.getRaisedError(state.getVariables());
        if (error == null) {
            log.debug("handle ['{}', '{}'] -> no errors, will continue from '{}'", new Object[]{state.getBusinessKey(), cmd.getElementId(), cmd.getElementId()});
            actions.add(new FollowFlowsAction(cmd.getDefinitionId(), cmd.getElementId()));
            actions.add(new PushCommandAction(new PerformActionsCommand(new PopScopeAction())));
            return actions;
        }
        IndexedProcessDefinition pd = state.getDefinition(cmd.getDefinitionId());
        BoundaryEvent ev = ProcessDefinitionUtils.findBoundaryErrorEvent(pd, cmd.getElementId(), error.getErrorRef());
        if (ev == null) {
            ev = ProcessDefinitionUtils.findBoundaryErrorEvent(pd, cmd.getElementId(), null);
        }
        if (ev == null) {
            switch (this.cfg.getUnhandledBpmnErrorStrategy()) {
                case EXCEPTION: {
                    throw new ExecutionException("Unhandled BPMN error: " + error.getErrorRef(), (Throwable)error);
                }
                case PROPAGATE: {
                    log.debug("handle ['{}', '{}'] -> propagating the error: '{}'", new Object[]{state.getBusinessKey(), cmd.getElementId(), error.getErrorRef()});
                    actions.add(new PushCommandAction(new PerformActionsCommand(new PopScopeAction())));
                    return actions;
                }
                case IGNORE: {
                    log.warn("handle ['{}', '{}'] -> unhandled BPMN error: '{}'", new Object[]{state.getBusinessKey(), cmd.getElementId(), error.getErrorRef()});
                    actions.add(BpmnErrorHelper.clear());
                    actions.add(new PushCommandAction(new PerformActionsCommand(new PopScopeAction())));
                    return actions;
                }
            }
        }
        List<SequenceFlow> flows = ProcessDefinitionUtils.findOptionalOutgoingFlows(pd, cmd.getElementId());
        log.debug("handle ['{}', '{}'] -> handling boundary error '{}'", new Object[]{state.getBusinessKey(), cmd.getElementId(), error.getErrorRef()});
        actions.add(BpmnErrorHelper.clear());
        actions.add(new SetVariableAction("lastError", error));
        actions.add(new ActivateElementAction(cmd.getDefinitionId(), ev.getId(), 1));
        actions.add(new PushCommandAction(new PerformActionsCommand(Arrays.asList(new ActivateFlowsAction(cmd.getDefinitionId(), ev.getId(), 1).addFlows(ProcessDefinitionUtils.toIds(flows), -1), new FollowFlowsAction(cmd.getDefinitionId(), ev.getId())))));
        actions.add(new PushCommandAction(new PerformActionsCommand(new PopScopeAction())));
        return actions;
    }
}

