/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.planner;

import io.takari.bpm.Configuration;
import io.takari.bpm.actions.Action;
import io.takari.bpm.api.ExecutionException;
import io.takari.bpm.commands.ActivityFinalizerCommand;
import io.takari.bpm.commands.Command;
import io.takari.bpm.commands.MergeVariablesCommand;
import io.takari.bpm.commands.PerformActionsCommand;
import io.takari.bpm.commands.ProcessElementCommand;
import io.takari.bpm.planner.ActivityFinalizerCommandHandler;
import io.takari.bpm.planner.CommandHandler;
import io.takari.bpm.planner.MergeVariablesCommandHandler;
import io.takari.bpm.planner.PerformActionCommandHandler;
import io.takari.bpm.planner.ProcessElementCommandHandler;
import io.takari.bpm.state.ProcessInstance;
import java.util.List;

public class DelegatingCommandHandler
implements CommandHandler<Command> {
    private final ProcessElementCommandHandler processElementCommandHandler;
    private final PerformActionCommandHandler performActionCommandHandler;
    private final ActivityFinalizerCommandHandler activityFinalizerCommandHandler;
    private final MergeVariablesCommandHandler mergeVariablesCommandHandler;

    public DelegatingCommandHandler(Configuration cfg) {
        this.processElementCommandHandler = new ProcessElementCommandHandler(cfg);
        this.performActionCommandHandler = new PerformActionCommandHandler();
        this.activityFinalizerCommandHandler = new ActivityFinalizerCommandHandler(cfg);
        this.mergeVariablesCommandHandler = new MergeVariablesCommandHandler();
    }

    @Override
    public List<Action> handle(ProcessInstance state, Command cmd, List<Action> actions) throws ExecutionException {
        if (cmd instanceof ProcessElementCommand) {
            return this.processElementCommandHandler.handle(state, (ProcessElementCommand)cmd, actions);
        }
        if (cmd instanceof PerformActionsCommand) {
            return this.performActionCommandHandler.handle(state, (PerformActionsCommand)cmd, actions);
        }
        if (cmd instanceof ActivityFinalizerCommand) {
            return this.activityFinalizerCommandHandler.handle(state, (ActivityFinalizerCommand)cmd, actions);
        }
        if (cmd instanceof MergeVariablesCommand) {
            return this.mergeVariablesCommandHandler.handle(state, (MergeVariablesCommand)cmd, actions);
        }
        throw new ExecutionException("Unsupported command: %s", new Object[]{cmd});
    }
}

