/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.planner;

import io.takari.bpm.actions.Action;
import io.takari.bpm.actions.MergeVariablesAction;
import io.takari.bpm.actions.PopCommandAction;
import io.takari.bpm.actions.SetVariablesAction;
import io.takari.bpm.api.BpmnError;
import io.takari.bpm.api.ExecutionException;
import io.takari.bpm.api.Variables;
import io.takari.bpm.commands.MergeVariablesCommand;
import io.takari.bpm.planner.CommandHandler;
import io.takari.bpm.state.BpmnErrorHelper;
import io.takari.bpm.state.ProcessInstance;
import java.util.List;

public class MergeVariablesCommandHandler
implements CommandHandler<MergeVariablesCommand> {
    @Override
    public List<Action> handle(ProcessInstance state, MergeVariablesCommand cmd, List<Action> actions) throws ExecutionException {
        actions.add(new PopCommandAction());
        Variables source = state.getVariables();
        Variables target = cmd.getTarget();
        actions.add(new SetVariablesAction(target));
        actions.add(new MergeVariablesAction(source, cmd.getOutVariables(), cmd.isCopyAllVariables()));
        BpmnError error = BpmnErrorHelper.getRaisedError(source);
        if (error != null) {
            actions.add(BpmnErrorHelper.raiseError(error));
        }
        return actions;
    }
}

