/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.reducers;

import com.google.common.collect.Lists;
import io.takari.bpm.IndexedProcessDefinition;
import io.takari.bpm.ProcessDefinitionUtils;
import io.takari.bpm.actions.Action;
import io.takari.bpm.actions.ActivateElementAction;
import io.takari.bpm.actions.CreateEventAction;
import io.takari.bpm.actions.ProcessEventGatewayAction;
import io.takari.bpm.actions.PushScopeAction;
import io.takari.bpm.api.ExecutionException;
import io.takari.bpm.commands.CommandStack;
import io.takari.bpm.commands.PerformActionsCommand;
import io.takari.bpm.model.AbstractElement;
import io.takari.bpm.model.IntermediateCatchEvent;
import io.takari.bpm.model.SequenceFlow;
import io.takari.bpm.reducers.Reducer;
import io.takari.bpm.state.ProcessInstance;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventGatewayReducer
implements Reducer {
    private static final Logger log = LoggerFactory.getLogger(EventGatewayReducer.class);

    @Override
    public ProcessInstance reduce(ProcessInstance state, Action action) throws ExecutionException {
        if (!(action instanceof ProcessEventGatewayAction)) {
            return state;
        }
        ProcessEventGatewayAction a = (ProcessEventGatewayAction)action;
        CommandStack stack = state.getStack();
        IndexedProcessDefinition pd = state.getDefinition(a.getDefinitionId());
        List<SequenceFlow> flows = ProcessDefinitionUtils.findOptionalOutgoingFlows(pd, a.getElementId());
        if (flows == null || flows.isEmpty()) {
            throw new ExecutionException("Invalid process definition '%s': event gateway '%s' must contain at least one event", new Object[]{a.getDefinitionId(), a.getElementId()});
        }
        for (SequenceFlow f : Lists.reverse(flows)) {
            AbstractElement e;
            if (f.getExpression() != null) {
                log.warn("reduce ['{}', '{}', '{}'] -> flow expressions are not supported for event gateways", (Object)state.getBusinessKey(), (Object)a);
            }
            if (!((e = ProcessDefinitionUtils.findElement(pd, f.getTo())) instanceof IntermediateCatchEvent)) {
                throw new ExecutionException("Invalid process definition '%s': event gateway '%s' must contain only intermediate catch events", new Object[]{a.getDefinitionId(), a.getElementId()});
            }
            IntermediateCatchEvent ice = (IntermediateCatchEvent)e;
            stack = stack.push(new PerformActionsCommand(new CreateEventAction(a.getDefinitionId(), ice))).push(new PerformActionsCommand(new ActivateElementAction(a.getDefinitionId(), e.getId(), 1)));
            stack = stack.push(new PerformActionsCommand(new ActivateElementAction(a.getDefinitionId(), f.getId(), 1)));
        }
        stack = stack.push(new PerformActionsCommand(new PushScopeAction(a.getDefinitionId(), a.getElementId(), true)));
        return state.setStack(stack);
    }
}

