/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.reducers;

import io.takari.bpm.ExecutionInterceptorHolder;
import io.takari.bpm.actions.Action;
import io.takari.bpm.actions.FireOnElementInterceptorsAction;
import io.takari.bpm.actions.FireOnFailureInterceptorsAction;
import io.takari.bpm.actions.FireOnFinishInterceptorsAction;
import io.takari.bpm.actions.FireOnResumeInterceptorsAction;
import io.takari.bpm.actions.FireOnScopeCreatedInterceptorsAction;
import io.takari.bpm.actions.FireOnScopeDestroyedInterceptorsAction;
import io.takari.bpm.actions.FireOnStartInterceptorsAction;
import io.takari.bpm.actions.FireOnSuspendInterceptorsAction;
import io.takari.bpm.actions.FireOnUnhandledErrorAction;
import io.takari.bpm.api.ExecutionException;
import io.takari.bpm.reducers.Impure;
import io.takari.bpm.reducers.Reducer;
import io.takari.bpm.state.ProcessInstance;
import java.util.Map;
import java.util.UUID;

@Impure
public class InterceptorEventsReducer
implements Reducer {
    private final ExecutionInterceptorHolder interceptors;

    public InterceptorEventsReducer(ExecutionInterceptorHolder interceptors) {
        this.interceptors = interceptors;
    }

    @Override
    public ProcessInstance reduce(ProcessInstance state, Action action) throws ExecutionException {
        if (action instanceof FireOnElementInterceptorsAction) {
            FireOnElementInterceptorsAction a = (FireOnElementInterceptorsAction)action;
            UUID scopeId = state.getScopes().getCurrentId();
            this.interceptors.fireOnElement(state.getVariables(), state.getBusinessKey(), a.getDefinitionId(), state.getId(), scopeId, a.getElementId());
        } else if (action instanceof FireOnStartInterceptorsAction) {
            FireOnStartInterceptorsAction a = (FireOnStartInterceptorsAction)action;
            this.interceptors.fireOnStart(state.getBusinessKey(), a.getDefinitionId(), state.getId(), InterceptorEventsReducer.getCurrentVariables(state));
        } else if (action instanceof FireOnSuspendInterceptorsAction) {
            this.interceptors.fireOnSuspend();
        } else if (action instanceof FireOnResumeInterceptorsAction) {
            this.interceptors.fireOnResume();
        } else if (action instanceof FireOnFinishInterceptorsAction) {
            this.interceptors.fireOnFinish(state.getBusinessKey());
        } else if (action instanceof FireOnFailureInterceptorsAction) {
            FireOnFailureInterceptorsAction a = (FireOnFailureInterceptorsAction)action;
            this.interceptors.fireOnFailure(state.getBusinessKey(), a.getErrorRef());
        } else if (action instanceof FireOnUnhandledErrorAction) {
            FireOnUnhandledErrorAction a = (FireOnUnhandledErrorAction)action;
            this.interceptors.fireOnUnhandledError(state.getBusinessKey(), a.getError());
        } else if (action instanceof FireOnScopeCreatedInterceptorsAction) {
            FireOnScopeCreatedInterceptorsAction a = (FireOnScopeCreatedInterceptorsAction)action;
            this.interceptors.fireOnScopeCreated(state.getBusinessKey(), a.getDefinitionId(), state.getId(), a.getScopeId(), a.getElementId());
        } else if (action instanceof FireOnScopeDestroyedInterceptorsAction) {
            FireOnScopeDestroyedInterceptorsAction a = (FireOnScopeDestroyedInterceptorsAction)action;
            this.interceptors.fireOnScopeDestroyed(state.getBusinessKey(), state.getId(), a.getScopeId());
        }
        return state;
    }

    private static Map<String, Object> getCurrentVariables(ProcessInstance state) {
        return state.getVariables().asMap();
    }
}

