/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.reducers;

import io.takari.bpm.actions.Action;
import io.takari.bpm.actions.RemoveInstanceAction;
import io.takari.bpm.actions.SuspendAndPersistAction;
import io.takari.bpm.api.ExecutionException;
import io.takari.bpm.api.Variables;
import io.takari.bpm.persistence.PersistenceManager;
import io.takari.bpm.reducers.Impure;
import io.takari.bpm.reducers.Reducer;
import io.takari.bpm.state.BpmnErrorHelper;
import io.takari.bpm.state.ProcessInstance;
import io.takari.bpm.state.ProcessStatus;

@Impure
public class PersistenceReducer
implements Reducer {
    private final PersistenceManager persistenceManager;

    public PersistenceReducer(PersistenceManager persistenceManager) {
        this.persistenceManager = persistenceManager;
    }

    @Override
    public ProcessInstance reduce(ProcessInstance state, Action action) throws ExecutionException {
        if (action instanceof SuspendAndPersistAction) {
            state = state.setStatus(ProcessStatus.SUSPENDED);
            ProcessInstance s = PersistenceReducer.clearErrors(state);
            this.persistenceManager.save(s);
        } else if (action instanceof RemoveInstanceAction) {
            RemoveInstanceAction a = (RemoveInstanceAction)action;
            this.persistenceManager.remove(a.getInstanceId());
        }
        return state;
    }

    private static ProcessInstance clearErrors(ProcessInstance state) {
        Variables vars = state.getVariables();
        if (vars == null) {
            return state;
        }
        return state.setVariables(BpmnErrorHelper.clear(vars));
    }
}

