/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.reducers;

import com.oracle.truffle.js.scriptengine.GraalJSEngineFactory;
import com.oracle.truffle.js.scriptengine.GraalJSScriptEngine;
import io.takari.bpm.Configuration;
import io.takari.bpm.IndexedProcessDefinition;
import io.takari.bpm.ProcessDefinitionUtils;
import io.takari.bpm.actions.Action;
import io.takari.bpm.actions.ExecuteScriptAction;
import io.takari.bpm.actions.FollowFlowsAction;
import io.takari.bpm.api.BpmnError;
import io.takari.bpm.api.ExecutionContext;
import io.takari.bpm.api.ExecutionContextFactory;
import io.takari.bpm.api.ExecutionException;
import io.takari.bpm.api.Variables;
import io.takari.bpm.commands.PerformActionsCommand;
import io.takari.bpm.context.ContextUtils;
import io.takari.bpm.context.ExecutionContextImpl;
import io.takari.bpm.model.ScriptTask;
import io.takari.bpm.reducers.BpmnErrorHandlingReducer;
import io.takari.bpm.reducers.Impure;
import io.takari.bpm.resource.ResourceResolver;
import io.takari.bpm.state.ProcessInstance;
import io.takari.bpm.state.VariablesHelper;
import io.takari.bpm.task.ServiceTaskRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.Value;

@Impure
public class ScriptReducer
extends BpmnErrorHandlingReducer {
    private final ExecutionContextFactory<? extends ExecutionContextImpl> contextFactory;
    private final ResourceResolver resourceResolver;
    private final ServiceTaskRegistry taskRegistry;
    private final ScriptEngineManager scriptEngineManager;

    public ScriptReducer(ExecutionContextFactory<? extends ExecutionContextImpl> contextFactory, Configuration cfg, ResourceResolver resourceResolver, ServiceTaskRegistry taskRegistry) {
        super(cfg);
        this.contextFactory = contextFactory;
        this.resourceResolver = resourceResolver;
        this.taskRegistry = taskRegistry;
        this.scriptEngineManager = new ScriptEngineManager();
    }

    @Override
    public ProcessInstance reduce(ProcessInstance state, Action action) throws ExecutionException {
        boolean resumeFromSameStep;
        if (!(action instanceof ExecuteScriptAction)) {
            return state;
        }
        ExecuteScriptAction a = (ExecuteScriptAction)action;
        IndexedProcessDefinition pd = state.getDefinition(a.getDefinitionId());
        ScriptTask t = (ScriptTask)ProcessDefinitionUtils.findElement(pd, a.getElementId());
        ExecutionContextImpl ctx = null;
        try {
            Variables vars = VariablesHelper.applyInVariables(this.contextFactory, state.getVariables(), t.getIn(), t.isCopyAllVariables());
            ctx = (ExecutionContextImpl)this.contextFactory.create(vars, a.getDefinitionId(), a.getElementId());
            t = this.interpolateScriptRef(ctx, t);
            ScriptEngine engine = this.getEngine(t);
            if (engine == null) {
                throw new ExecutionException("Script engine not found: " + t.getLanguage());
            }
            Bindings b = engine.createBindings();
            b.put("polyglot.js.allowAllAccess", (Object)true);
            b.put("execution", (Object)ctx);
            b.put("tasks", (Object)new TaskAccessor(this.taskRegistry));
            b.putAll((Map<? extends String, ? extends Object>)ctx.toMap());
            Throwable throwable = null;
            Object var11_16 = null;
            try (Reader input = this.openReader(t);){
                engine.eval(input, b);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            PerformActionsCommand next = new PerformActionsCommand(new FollowFlowsAction(a.getDefinitionId(), a.getElementId()));
            state = ContextUtils.handleSuspend(state, ctx, a.getDefinitionId(), a.getElementId(), next);
        }
        catch (BpmnError e) {
            state = this.handleBpmnError(state, a, e);
        }
        catch (ExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            state = this.handleException(state, a, e);
        }
        boolean bl = resumeFromSameStep = ctx != null && ctx.getSuspendMessageRef() != null && ctx.isResumeFromSameStep();
        if (!resumeFromSameStep) {
            state = VariablesHelper.applyOutVariables(this.contextFactory, state, ctx, t.getOut());
        }
        return state;
    }

    private ScriptTask interpolateScriptRef(ExecutionContext ctx, ScriptTask t) {
        if (t.getType() != ScriptTask.Type.REFERENCE) {
            return t;
        }
        String ref = (String)ctx.interpolate((Object)t.getContent());
        return new ScriptTask(t.getId(), t.getType(), t.getLanguage(), ref, t.getIn(), t.getOut());
    }

    private ScriptEngine getEngine(ScriptTask t) throws ExecutionException {
        if (t.getLanguage() != null) {
            if (new GraalJSEngineFactory().getNames().contains(t.getLanguage())) {
                return ScriptReducer.initializeGraalVm();
            }
            return this.scriptEngineManager.getEngineByName(t.getLanguage());
        }
        if (t.getContent() == null) {
            throw new ExecutionException("Script task must have a language set or a path to an external script: " + t.getId());
        }
        String ext = ScriptReducer.getExtension(t.getContent());
        if (ext == null) {
            throw new ExecutionException("Unknown external script extension: " + t.getContent());
        }
        if (new GraalJSEngineFactory().getExtensions().contains(ext)) {
            return ScriptReducer.initializeGraalVm();
        }
        return this.scriptEngineManager.getEngineByExtension(ext);
    }

    private Reader openReader(ScriptTask t) throws ExecutionException {
        ScriptTask.Type type = t.getType();
        if (type == ScriptTask.Type.REFERENCE) {
            String ref = t.getContent();
            try {
                InputStream in = this.resourceResolver.getResourceAsStream(ref);
                if (in == null) {
                    throw new ExecutionException("Resource not found: " + ref);
                }
                return new InputStreamReader(in);
            }
            catch (IOException iOException) {
                throw new ExecutionException("Can't open resource: " + ref);
            }
        }
        if (type == ScriptTask.Type.CONTENT) {
            return new StringReader(t.getContent());
        }
        throw new ExecutionException("Unsupported script task type: " + type);
    }

    private ProcessInstance handleException(ProcessInstance state, ExecuteScriptAction a, Exception e) throws ExecutionException {
        return this.handleException(state, a.getDefinitionId(), a.getElementId(), e, a.getErrors(), a.getDefaultError());
    }

    private ProcessInstance handleBpmnError(ProcessInstance state, ExecuteScriptAction a, BpmnError e) throws ExecutionException {
        return this.handleBpmnError(state, a.getDefinitionId(), a.getElementId(), e, a.getErrors(), a.getDefaultError());
    }

    private static ScriptEngine initializeGraalVm() {
        HostAccess access = HostAccess.newBuilder((HostAccess)HostAccess.ALL).targetTypeMapping(Value.class, Object.class, Value::hasArrayElements, v -> new LinkedList((Collection)v.as(List.class))).build();
        return GraalJSScriptEngine.create((Engine)Engine.newBuilder().allowExperimentalOptions(true).option("engine.WarnInterpreterOnly", "false").option("js.nashorn-compat", "true").build(), (Context.Builder)Context.newBuilder((String[])new String[]{"js"}).allowHostAccess(access));
    }

    private static String getExtension(String s) {
        if (s == null) {
            return null;
        }
        int i = s.lastIndexOf(".");
        if (i < 0 || i + 1 >= s.length()) {
            return null;
        }
        return s.substring(i + 1);
    }

    public static class TaskAccessor {
        private final ServiceTaskRegistry taskRegistry;

        public TaskAccessor(ServiceTaskRegistry taskRegistry) {
            this.taskRegistry = taskRegistry;
        }

        public Object get(String key) {
            return this.taskRegistry.getByKey(key);
        }
    }
}

