/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.reducers;

import io.takari.bpm.actions.Action;
import io.takari.bpm.actions.InterpolateCurrentVariablesAction;
import io.takari.bpm.actions.MakeSubProcessVariablesAction;
import io.takari.bpm.actions.MergeVariablesAction;
import io.takari.bpm.actions.SetVariableAction;
import io.takari.bpm.actions.SetVariablesAction;
import io.takari.bpm.actions.UnsetVariableAction;
import io.takari.bpm.api.ExecutionContextFactory;
import io.takari.bpm.api.ExecutionException;
import io.takari.bpm.api.Variables;
import io.takari.bpm.context.ExecutionContextImpl;
import io.takari.bpm.reducers.Impure;
import io.takari.bpm.reducers.Reducer;
import io.takari.bpm.state.ProcessInstance;
import io.takari.bpm.state.VariablesHelper;

@Impure
public class VariablesReducer
implements Reducer {
    private final ExecutionContextFactory<? extends ExecutionContextImpl> contextFactory;

    public VariablesReducer(ExecutionContextFactory<? extends ExecutionContextImpl> contextFactory) {
        this.contextFactory = contextFactory;
    }

    @Override
    public ProcessInstance reduce(ProcessInstance state, Action action) throws ExecutionException {
        if (action instanceof SetVariableAction) {
            SetVariableAction a = (SetVariableAction)action;
            Variables vars = state.getVariables();
            return state.setVariables(vars.setVariable(a.getKey(), a.getValue()));
        }
        if (action instanceof UnsetVariableAction) {
            UnsetVariableAction a = (UnsetVariableAction)action;
            Variables vars = state.getVariables();
            return state.setVariables(vars.removeVariable(a.getKey()));
        }
        if (action instanceof SetVariablesAction) {
            SetVariablesAction a = (SetVariablesAction)action;
            return state.setVariables(a.getVariables());
        }
        if (action instanceof MergeVariablesAction) {
            MergeVariablesAction a = (MergeVariablesAction)action;
            Variables src = a.getSource();
            Variables dst = state.getVariables();
            if (a.isCopyAllVariables()) {
                dst = VariablesHelper.copyVariables(src, dst);
            }
            dst = VariablesHelper.copyVariables(this.contextFactory, src, dst, a.getOutVariables());
            return state.setVariables(dst);
        }
        if (action instanceof MakeSubProcessVariablesAction) {
            MakeSubProcessVariablesAction a = (MakeSubProcessVariablesAction)action;
            Variables src = state.getVariables();
            Variables dst = new Variables();
            if (a.isCopyAllVariables()) {
                dst = VariablesHelper.copyVariables(src, dst);
            }
            dst = VariablesHelper.copyVariables(this.contextFactory, src, dst, a.getInVariables());
            return state.setVariables(dst);
        }
        if (action instanceof InterpolateCurrentVariablesAction) {
            return VariablesHelper.interpolate(this.contextFactory, state);
        }
        return state;
    }
}

