/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.state;

import io.takari.bpm.state.Scopes;
import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import org.pcollections.HashTreePMap;
import org.pcollections.PMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activations
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Activations.class);
    private static final long serialVersionUID = 1L;
    private final PMap<ActivationKey, Activation> values;

    public Activations() {
        this.values = HashTreePMap.empty();
    }

    private Activations(PMap<ActivationKey, Activation> values) {
        this.values = values;
    }

    public Activations incExpectation(Scopes scopes, UUID scope, String elementId, int count) {
        ActivationKey k = new ActivationKey(scope, elementId);
        Activation v = Activation.notEmpty((Activation)this.values.get((Object)k), scope + ":" + elementId);
        log.debug("Incrementing {} ({}/{}+{})", new Object[]{v.id, v.getReceived(), v.getExpected(), count});
        return new Activations((PMap<ActivationKey, Activation>)this.values.plus((Object)k, (Object)v.incExpected(count)));
    }

    public Activations inc(Scopes scopes, UUID scope, String elementId, int count) {
        while (scope != null) {
            ActivationKey k = new ActivationKey(scope, elementId);
            Activation v = (Activation)this.values.get((Object)k);
            if (v != null) {
                log.debug("Incrementing {} ({}+{}/{})", new Object[]{v.id, v.getReceived(), count, v.getExpected()});
                return new Activations((PMap<ActivationKey, Activation>)this.values.plus((Object)k, (Object)v.incReceived(count)));
            }
            scope = scopes.values().get(scope).getParentId();
        }
        throw new IllegalStateException("Cannot find activationKey for " + scope + ":" + elementId);
    }

    public Activation getActivation(Scopes scopes, UUID scope, String elementId) {
        while (scope != null) {
            ActivationKey k = new ActivationKey(scope, elementId);
            Activation v = (Activation)this.values.get((Object)k);
            if (v != null) {
                return v;
            }
            scope = scopes.values().get(scope).getParentId();
        }
        return Activation.notEmpty(null, scope + ":" + elementId);
    }

    public Map<ActivationKey, Activation> values() {
        return this.values;
    }

    public static final class Activation
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String id;
        private final int expected;
        private final int received;
        private final boolean activated;

        public static final Activation notEmpty(Activation act, String id) {
            if (act == null) {
                act = new Activation(id, 0, 0, false);
            }
            return act;
        }

        Activation(String id, int expected, int received, boolean activated) {
            this.id = id;
            this.expected = expected;
            this.received = received;
            this.activated = activated;
        }

        public boolean isActivated() {
            return this.activated;
        }

        public int getExpected() {
            return this.expected;
        }

        public int getReceived() {
            return this.received;
        }

        public Activation incExpected(int count) {
            return new Activation(this.id, this.expected + count, this.received, true);
        }

        public Activation incReceived(int count) {
            if (!this.activated) {
                throw new IllegalStateException("Incrementing " + this.id + " 'received' but the flow hasn't been activated yet");
            }
            if (this.received + count > this.expected) {
                throw new IllegalStateException("Incrementing " + this.id + " 'received' to " + this.received + " + " + count + " but the flow expects " + this.expected + " max");
            }
            return new Activation(this.id, this.expected, this.received + count, true);
        }

        public String toString() {
            return "[" + this.id + "] " + this.received + "/" + this.expected;
        }
    }

    public static final class ActivationKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final UUID scopeId;
        private final String elementId;

        public ActivationKey(UUID scopeId, String elementId) {
            this.scopeId = scopeId;
            this.elementId = elementId;
        }

        public UUID getScopeId() {
            return this.scopeId;
        }

        public String getElementId() {
            return this.elementId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ActivationKey that = (ActivationKey)o;
            if (!this.scopeId.equals(that.scopeId)) {
                return false;
            }
            return this.elementId.equals(that.elementId);
        }

        public int hashCode() {
            int result = this.scopeId.hashCode();
            result = 31 * result + this.elementId.hashCode();
            return result;
        }
    }
}

