/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.state;

import io.takari.bpm.commands.Command;
import io.takari.bpm.commands.CommandStack;
import io.takari.bpm.state.ProcessInstance;
import io.takari.bpm.state.Scopes;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.pcollections.HashTreePMap;
import org.pcollections.PMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Events
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Events.class);
    private final PMap<UUID, PMap<UUID, EventRecord>> events;

    public Events() {
        this((PMap<UUID, PMap<UUID, EventRecord>>)HashTreePMap.empty());
    }

    private Events(PMap<UUID, PMap<UUID, EventRecord>> events) {
        this.events = events;
    }

    public Events addEvent(UUID scopeId, UUID eventId, String name, Command ... commands) {
        PMap scope = (PMap)this.events.get((Object)scopeId);
        if (scope == null) {
            scope = HashTreePMap.empty();
        }
        EventRecord r = new EventRecord(name, commands);
        scope = scope.plus((Object)eventId, (Object)r);
        return new Events((PMap<UUID, PMap<UUID, EventRecord>>)this.events.plus((Object)scopeId, (Object)scope));
    }

    public Events clearScope(UUID scopeId) {
        return new Events((PMap<UUID, PMap<UUID, EventRecord>>)this.events.minus((Object)scopeId));
    }

    public Events removeEvent(UUID scopeId, UUID eventId) {
        PMap scope = (PMap)this.events.get((Object)scopeId);
        if (scope == null) {
            throw new IllegalArgumentException("Scope not found: " + scopeId);
        }
        if ((scope = scope.minus((Object)eventId)).isEmpty()) {
            return new Events((PMap<UUID, PMap<UUID, EventRecord>>)this.events.minus((Object)scopeId));
        }
        return new Events((PMap<UUID, PMap<UUID, EventRecord>>)this.events.plus((Object)scopeId, (Object)scope));
    }

    public ProcessInstance pushCommands(ProcessInstance state, UUID scopeId, UUID eventId) {
        Map scope = (Map)this.events.get((Object)scopeId);
        if (scope == null) {
            throw new IllegalArgumentException("Scope not found: " + scopeId);
        }
        EventRecord r = (EventRecord)scope.get(eventId);
        if (r == null) {
            throw new IllegalArgumentException("Event not found: " + eventId);
        }
        if (r.getCommands() == null || r.getCommands().length == 0) {
            log.warn("pushCommands ['{}', '{}'] -> event has no commands", (Object)state.getBusinessKey(), (Object)eventId);
            return state;
        }
        CommandStack stack = state.getStack();
        Command[] commandArray = r.getCommands();
        int n = commandArray.length;
        int n2 = 0;
        while (n2 < n) {
            Command c = commandArray[n2];
            stack = stack.push(c);
            ++n2;
        }
        return state.setStack(stack);
    }

    public boolean isEmpty() {
        int count = 0;
        for (Map.Entry e : this.events.entrySet()) {
            count += ((PMap)e.getValue()).size();
        }
        return count == 0;
    }

    public boolean isEmpty(Scopes scopes, UUID scopeId) {
        Map<UUID, Scopes.Scope> m = scopes.values();
        Map em = (Map)this.events.get((Object)scopeId);
        if (em != null && !em.isEmpty()) {
            log.debug("isEmpty ['{}'] -> false", (Object)scopeId);
            return false;
        }
        for (Map.Entry<UUID, Scopes.Scope> e : m.entrySet()) {
            Scopes.Scope next = e.getValue();
            if (!scopeId.equals(next.getParentId()) || this.isEmpty(scopes, next.getId())) continue;
            return false;
        }
        log.debug("isEmpty ['{}'] -> true", (Object)scopeId);
        return true;
    }

    public Map<UUID, Map<UUID, EventRecord>> values() {
        HashMap<UUID, Map<UUID, EventRecord>> result = new HashMap<UUID, Map<UUID, EventRecord>>(this.events.size());
        for (Map.Entry e : this.events.entrySet()) {
            UUID k = (UUID)e.getKey();
            PMap v = (PMap)e.getValue();
            result.put(k, (Map<UUID, EventRecord>)v);
        }
        return result;
    }

    public static final class EventRecord
    implements Serializable {
        private final String name;
        private final Command[] commands;

        public EventRecord(String name, Command ... commands) {
            this.name = name;
            this.commands = commands;
        }

        public Command[] getCommands() {
            return this.commands;
        }

        public String toString() {
            return "EventRecord[name=" + this.name + ", commands=" + Arrays.toString(this.commands) + ']';
        }
    }
}

