/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.state;

import io.takari.bpm.commands.Command;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.pcollections.HashTreePMap;
import org.pcollections.PMap;

public class Scopes
implements Serializable {
    private final UUID currentId;
    private final PMap<UUID, Scope> scopes;

    public Scopes() {
        this(null, (PMap<UUID, Scope>)HashTreePMap.empty());
    }

    private Scopes(UUID currentId, PMap<UUID, Scope> scopes) {
        this.currentId = currentId;
        this.scopes = scopes;
    }

    public UUID getCurrentId() {
        return this.currentId;
    }

    public Scopes setCurrentId(UUID scopeId) {
        if (!this.scopes.containsKey((Object)scopeId)) {
            throw new IllegalArgumentException("Unknown scope: " + scopeId);
        }
        return new Scopes(scopeId, this.scopes);
    }

    public Scopes push(UUID id, boolean exclusive, Command ... finishers) {
        Scope parent = this.currentId != null ? (Scope)this.scopes.get((Object)this.currentId) : null;
        UUID parentId = parent != null ? parent.getId() : null;
        Scope s = new Scope(parentId, id, exclusive, finishers);
        return new Scopes(id, (PMap<UUID, Scope>)this.scopes.plus((Object)id, (Object)s));
    }

    public Scope peek() {
        if (this.currentId == null) {
            throw new IllegalArgumentException("No current scope");
        }
        Scope s = (Scope)this.scopes.get((Object)this.currentId);
        if (s == null) {
            throw new IllegalStateException("Invalid current scope ID: " + this.currentId);
        }
        return s;
    }

    public Scopes pop() {
        if (this.currentId == null) {
            throw new IllegalStateException("Invalid state: no scope to pop");
        }
        Scope s = (Scope)this.scopes.get((Object)this.currentId);
        if (s == null) {
            throw new IllegalStateException("Invalid current scope ID: " + this.currentId);
        }
        return new Scopes(s.getParentId(), this.scopes);
    }

    public Map<UUID, Scope> values() {
        return this.scopes;
    }

    public List<Scope> traverse(UUID scopeId) {
        ArrayList<Scope> result = new ArrayList<Scope>();
        UUID id = scopeId;
        while (id != null) {
            Scope s = (Scope)this.scopes.get((Object)id);
            if (s == null) {
                throw new IllegalStateException("Scope not found: " + id);
            }
            result.add(s);
            id = s.getParentId();
        }
        return result;
    }

    public Scopes remove(UUID scopeId) {
        if (scopeId == this.currentId) {
            throw new IllegalArgumentException("Can't remove the current scope: " + scopeId);
        }
        return new Scopes(this.currentId, (PMap<UUID, Scope>)this.scopes.minus((Object)scopeId));
    }

    public String toString() {
        return "Scopes[currentId=" + this.currentId + ", scopes=" + this.scopes + ']';
    }

    public static class Scope
    implements Serializable {
        private final UUID parentId;
        private final UUID id;
        private final boolean exclusive;
        private final Command[] finishers;

        public Scope(UUID parentId, UUID id, boolean exclusive, Command[] finishers) {
            this.parentId = parentId;
            this.id = id;
            this.exclusive = exclusive;
            this.finishers = finishers;
        }

        public UUID getParentId() {
            return this.parentId;
        }

        public UUID getId() {
            return this.id;
        }

        public boolean isExclusive() {
            return this.exclusive;
        }

        public Command[] getFinishers() {
            return this.finishers;
        }

        public String toString() {
            return "Scope[parentId=" + this.parentId + ", id=" + this.id + ", exclusive=" + this.exclusive + ", finishers=" + Arrays.toString(this.finishers) + ']';
        }
    }
}

