/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.apt;

import io.takari.builder.internal.model.BuilderClass;
import io.takari.builder.internal.model.MemberAdapter;
import io.takari.builder.internal.model.MethodAdapter;
import io.takari.builder.internal.model.TypeAdapter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

class APT {
    private final Elements elements;
    private final Types types;

    public APT(Elements elements, Types types) {
        this.elements = elements;
        this.types = types;
    }

    TypeMirror asTypeMirrorErasure(Class<?> type) {
        return this.types.erasure(this.elements.getTypeElement(type.getCanonicalName()).asType());
    }

    List<MemberAdapter> getAllMembers(TypeElement type) {
        ArrayList<MemberAdapter> result = new ArrayList<MemberAdapter>();
        TypeMirror superclass = type.getSuperclass();
        if (superclass instanceof NoType) {
            return Collections.emptyList();
        }
        result.addAll(this.getAllMembers((TypeElement)this.types.asElement(superclass)));
        type.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.FIELD).map(e -> new APTMember((Element)e)).forEach(m -> {
            boolean bl = result.add((MemberAdapter)m);
        });
        return result;
    }

    public BuilderClass createBuilderClass(TypeElement type) {
        return BuilderClass.create((TypeAdapter)new APTType(type.asType()));
    }

    APTType adapt(TypeMirror type) {
        return new APTType(type);
    }

    public class APTMember
    implements MemberAdapter {
        private final Element adaptee;

        public APTMember(Element adaptee) {
            this.adaptee = adaptee;
        }

        public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
            return this.adaptee.getAnnotation(annotationClass) != null;
        }

        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return this.adaptee.getAnnotation(annotationClass);
        }

        public Element adaptee() {
            return this.adaptee;
        }

        public String getName() {
            return this.adaptee.getSimpleName().toString();
        }

        public APTType getDeclaringType() {
            return new APTType(this.adaptee.getEnclosingElement().asType());
        }

        public List<TypeAdapter> getParameterTypes() {
            ArrayList<? extends TypeMirror> parameterTypes = new ArrayList<TypeMirror>();
            TypeMirror type = this.adaptee.asType();
            if (type instanceof ArrayType) {
                parameterTypes.add(((ArrayType)type).getComponentType());
            } else if (type instanceof DeclaredType) {
                parameterTypes.addAll(((DeclaredType)type).getTypeArguments());
            }
            return parameterTypes.stream().filter(t -> t.getKind().isPrimitive() || t.getKind() == TypeKind.DECLARED).map(m -> new APTType((TypeMirror)m)).collect(Collectors.toList());
        }

        public APTType getType() {
            return new APTType(this.adaptee.asType());
        }

        public boolean isDeprecated() {
            return this.adaptee.getAnnotation(Deprecated.class) != null;
        }

        public String getJavadoc() {
            return APT.this.elements.getDocComment(this.adaptee);
        }

        public String toString() {
            return this.adaptee.toString();
        }
    }

    public class APTMethod
    implements MethodAdapter {
        private final ExecutableElement adaptee;

        public APTMethod(ExecutableElement adaptee) {
            this.adaptee = adaptee;
        }

        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return this.adaptee.getAnnotation(annotationClass);
        }

        public int getParameterCount() {
            return this.adaptee.getParameters().size();
        }

        public Element adaptee() {
            return this.adaptee;
        }
    }

    public class APTType
    implements TypeAdapter {
        private final TypeMirror adaptee;

        public APTType(TypeMirror adaptee) {
            assert (adaptee instanceof PrimitiveType || adaptee instanceof DeclaredType || adaptee instanceof ArrayType);
            this.adaptee = adaptee;
        }

        public TypeMirror adaptee() {
            return this.adaptee;
        }

        public String qualifiedName() {
            if (this.isPrimitive()) {
                return this.adaptee.toString();
            }
            return this.asTypeElement().getQualifiedName().toString();
        }

        public String simpleName() {
            if (this.isPrimitive()) {
                return this.adaptee.getKind().toString();
            }
            return this.asTypeElement().getSimpleName().toString();
        }

        PackageElement getPackageElement() {
            if (this.isPrimitive()) {
                throw new UnsupportedOperationException();
            }
            return APT.this.elements.getPackageOf(this.asTypeElement());
        }

        public boolean isPrimitive() {
            return this.adaptee instanceof PrimitiveType;
        }

        public boolean isIterable() {
            return APT.this.types.isAssignable(APT.this.types.erasure(this.adaptee), APT.this.asTypeMirrorErasure(Iterable.class));
        }

        public boolean isMap() {
            return APT.this.types.isAssignable(APT.this.types.erasure(this.adaptee), APT.this.asTypeMirrorErasure(Map.class));
        }

        public boolean isEnum() {
            return APT.this.types.isSubtype(APT.this.types.erasure(this.adaptee), APT.this.asTypeMirrorErasure(Enum.class));
        }

        public boolean isSameType(Class<?> type) {
            return APT.this.types.isSameType(APT.this.types.erasure(this.adaptee), APT.this.asTypeMirrorErasure(type));
        }

        private TypeElement asTypeElement() {
            return (TypeElement)((DeclaredType)this.adaptee).asElement();
        }

        private boolean isDeclaredType() {
            return this.adaptee instanceof DeclaredType;
        }

        public List<MemberAdapter> getAllMembers() {
            if (this.isPrimitive()) {
                return Collections.emptyList();
            }
            return APT.this.getAllMembers(this.asTypeElement());
        }

        public List<MethodAdapter> getMethods() {
            if (this.isPrimitive()) {
                return Collections.emptyList();
            }
            return this.asTypeElement().getEnclosedElements().stream().filter(m -> m.getKind() == ElementKind.METHOD).map(m -> new APTMethod((ExecutableElement)m)).collect(Collectors.toList());
        }

        public String toString() {
            return this.adaptee.toString();
        }

        public boolean isInterface() {
            return this.isDeclaredType() && this.asTypeElement().getKind() == ElementKind.INTERFACE;
        }

        public boolean isLocalClass() {
            return this.isDeclaredType() && this.asTypeElement().getNestingKind() == NestingKind.LOCAL;
        }

        public boolean isAnonymousClass() {
            return this.isDeclaredType() && this.asTypeElement().getNestingKind() == NestingKind.ANONYMOUS;
        }

        public boolean isInnerClass() {
            if (!this.isDeclaredType()) {
                return false;
            }
            TypeElement typeElement = this.asTypeElement();
            return typeElement.getNestingKind() == NestingKind.MEMBER && typeElement.getModifiers().contains((Object)Modifier.STATIC);
        }

        public boolean isAbstract() {
            return this.isDeclaredType() && this.asTypeElement().getModifiers().contains((Object)Modifier.ABSTRACT);
        }

        public boolean isArray() {
            return this.adaptee.getKind() == TypeKind.ARRAY;
        }

        public boolean isAssignableFrom(Class<?> type) {
            return APT.this.types.isAssignable(APT.this.asTypeMirrorErasure(type), APT.this.types.erasure(this.adaptee));
        }

        public boolean hasNoargConstructor() {
            if (this.isPrimitive()) {
                return false;
            }
            TypeElement typeElement = this.asTypeElement();
            return ElementFilter.constructorsIn(typeElement.getEnclosedElements()).stream().anyMatch(m -> m.getParameters().isEmpty());
        }
    }
}

