/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.apt;

import io.takari.builder.apt.APT;
import io.takari.builder.apt.MojoGenerationVisitor;
import io.takari.builder.internal.model.AbstractParameter;
import io.takari.builder.internal.model.BuilderClass;
import io.takari.builder.internal.model.BuilderMetadataVisitor;
import io.takari.builder.internal.model.BuilderMethod;
import io.takari.builder.internal.model.BuilderValidationVisitor;
import java.lang.annotation.Annotation;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class BuilderMojoGenerator
extends AbstractProcessor {
    private Filer filer;
    private Messager messager;
    private APT apt;

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        super.init(env);
        this.filer = env.getFiler();
        this.messager = env.getMessager();
        this.apt = new APT(env.getElementUtils(), env.getTypeUtils());
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> annotations = new LinkedHashSet<String>();
        annotations.add("io.takari.builder.*");
        return annotations;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        BuilderClass.annotations().stream().flatMap(a -> env.getElementsAnnotatedWith((Class<? extends Annotation>)a).stream()).map(m -> (TypeElement)m.getEnclosingElement()).distinct().forEach(m -> this.process((TypeElement)m, env));
        return false;
    }

    private void process(TypeElement type, RoundEnvironment env) {
        BuilderClass metadata = this.apt.createBuilderClass(type);
        APTValidationVisitor validator = new APTValidationVisitor();
        metadata.accept((BuilderMetadataVisitor)validator);
        if (!validator.errorRaised) {
            metadata.accept((BuilderMetadataVisitor)new MojoGenerationVisitor(this.filer, this.messager));
        }
    }

    private class APTValidationVisitor
    extends BuilderValidationVisitor {
        public boolean errorRaised;

        private APTValidationVisitor() {
        }

        protected void error(AbstractParameter parameter, String message) {
            APT.APTMember element = (APT.APTMember)parameter.originatingElement();
            this.error(element.adaptee(), message);
        }

        protected void error(BuilderMethod builder, String message) {
            APT.APTMethod builderMethod = (APT.APTMethod)builder.originatingElement();
            this.error(builderMethod.adaptee(), message);
        }

        private void error(Element element, String message) {
            BuilderMojoGenerator.this.messager.printMessage(Diagnostic.Kind.ERROR, message, element);
            this.errorRaised = true;
        }
    }
}

