/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.apt;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import io.takari.builder.Builder;
import io.takari.builder.apt.APT;
import io.takari.builder.internal.maven.AbstractIncrementalMojo;
import io.takari.builder.internal.model.AbstractParameter;
import io.takari.builder.internal.model.ArtifactResourcesParameter;
import io.takari.builder.internal.model.BuilderMetadataVisitor;
import io.takari.builder.internal.model.BuilderMethod;
import io.takari.builder.internal.model.CompositeParameter;
import io.takari.builder.internal.model.DependenciesParameter;
import io.takari.builder.internal.model.DependencyResourcesParameter;
import io.takari.builder.internal.model.GeneratedResourcesDirectoryParameter;
import io.takari.builder.internal.model.GeneratedSourcesDirectoryParameter;
import io.takari.builder.internal.model.InputDirectoryFilesParameter;
import io.takari.builder.internal.model.InputDirectoryParameter;
import io.takari.builder.internal.model.InputFileParameter;
import io.takari.builder.internal.model.MapParameter;
import io.takari.builder.internal.model.MultivalueParameter;
import io.takari.builder.internal.model.OutputDirectoryParameter;
import io.takari.builder.internal.model.OutputFileParameter;
import io.takari.builder.internal.model.SimpleParameter;
import io.takari.builder.internal.model.TypeAdapter;
import io.takari.builder.internal.model.UnsupportedCollectionParameter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.configuration.PlexusConfiguration;

public class MojoGenerationVisitor
implements BuilderMetadataVisitor {
    private final Filer filer;
    private final Messager messager;
    private final List<FieldSpec> fields = new ArrayList<FieldSpec>();
    private final Set<TypeElement> types = new LinkedHashSet<TypeElement>();

    public MojoGenerationVisitor(Filer filer, Messager messager) {
        this.filer = filer;
        this.messager = messager;
    }

    private static MethodSpec buildConstructorSpec(TypeAdapter typeElement) {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super($T.class)", new Object[]{((APT.APTType)typeElement).adaptee()}).build();
    }

    private String getMojoClassname(BuilderMethod metadata) {
        String classname = ((APT.APTType)metadata.declaringType()).simpleName();
        String goalname = metadata.annotation().name().replace('-', '_');
        return String.valueOf(classname) + "$GeneratedMojo$" + goalname;
    }

    private String getMojoPackagename(BuilderMethod metadata) {
        APT.APTType type = (APT.APTType)metadata.declaringType();
        return type.getPackageElement().getQualifiedName().toString();
    }

    private void addField(AbstractParameter metadata) {
        FieldSpec fieldSpec;
        String javadoc;
        APT.APTMember element = (APT.APTMember)metadata.originatingElement();
        FieldSpec.Builder builder = FieldSpec.builder(PlexusConfiguration.class, (String)metadata.name(), (Modifier[])new Modifier[0]);
        builder.addAnnotation(Parameter.class);
        if (element.isDeprecated()) {
            builder.addAnnotation(Deprecated.class);
        }
        if ((javadoc = element.getJavadoc()) != null) {
            builder.addJavadoc(javadoc, new Object[0]);
        }
        if (!this.fields.contains(fieldSpec = builder.build())) {
            this.fields.add(fieldSpec);
            this.types.add((TypeElement)element.adaptee().getEnclosingElement());
        }
    }

    public void visitBuilder(BuilderMethod metadata) {
        Builder ann = metadata.annotation();
        String defaultPhase = ann.defaultPhase().name();
        AnnotationSpec.Builder annBuilder = AnnotationSpec.builder(Mojo.class).addMember("name", "$S", new Object[]{ann.name()}).addMember("defaultPhase", "$T.$L", new Object[]{LifecyclePhase.class, defaultPhase}).addMember("requiresProject", "$L", new Object[]{true}).addMember("requiresDependencyResolution", "$T.$L", new Object[]{ResolutionScope.class, ResolutionScope.NONE}).addMember("threadSafe", "$L", new Object[]{true});
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)this.getMojoClassname(metadata)).superclass(AbstractIncrementalMojo.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(annBuilder.build()).addFields(this.fields).addMethod(MojoGenerationVisitor.buildConstructorSpec(metadata.declaringType()));
        APT.APTMethod element = (APT.APTMethod)metadata.originatingElement();
        TypeElement type = (TypeElement)element.adaptee().getEnclosingElement();
        classBuilder.addOriginatingElement((Element)type);
        if (metadata.isNonDeterministic()) {
            this.messager.printMessage(Diagnostic.Kind.WARNING, "This Builder is declared as non-deterministic. This is BAD. Please Fix this asap.", type);
        }
        if (this.types.size() != 1 || !this.types.contains(type)) {
            this.messager.printMessage(Diagnostic.Kind.WARNING, "Builder extends other classes. Generated mojo may be incomplete. Make sure to run full build", type);
        }
        String pkgname = this.getMojoPackagename(metadata);
        try {
            JavaFile.builder((String)pkgname, (TypeSpec)classBuilder.build()).build().writeTo(this.filer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public boolean enterMultivalue(MultivalueParameter metadata) {
        this.addField((AbstractParameter)metadata);
        return true;
    }

    public void visitUnsupportedCollection(UnsupportedCollectionParameter metadata) {
        throw new IllegalArgumentException();
    }

    public boolean enterComposite(CompositeParameter metadata) {
        this.addField((AbstractParameter)metadata);
        return false;
    }

    public void visitMap(MapParameter metadata) {
        this.addField((AbstractParameter)metadata);
    }

    public void visitSimple(SimpleParameter metadata) {
        this.addField((AbstractParameter)metadata);
    }

    public void visitInputDirectory(InputDirectoryParameter metadata) {
        this.addField((AbstractParameter)metadata);
    }

    public void visitInputDirectoryFiles(InputDirectoryFilesParameter metadata) {
        this.addField((AbstractParameter)metadata);
    }

    public void visitDependencies(DependenciesParameter metadata) {
        this.addField((AbstractParameter)metadata);
    }

    public void visitOutputDirectory(OutputDirectoryParameter metadata) {
        this.addField((AbstractParameter)metadata);
    }

    public void visitOutputFile(OutputFileParameter metadata) {
        this.addField((AbstractParameter)metadata);
    }

    public void visitGeneratedSourcesDirectory(GeneratedSourcesDirectoryParameter metadata) {
        this.addField((AbstractParameter)metadata);
    }

    public void visitGeneratedResourcesDirectory(GeneratedResourcesDirectoryParameter metadata) {
        this.addField((AbstractParameter)metadata);
    }

    public void visitInputFile(InputFileParameter metadata) {
        this.addField((AbstractParameter)metadata);
    }

    public void visitDependencyResources(DependencyResourcesParameter metadata) {
        this.addField((AbstractParameter)metadata);
    }

    public void visitArtifactResources(ArtifactResourcesParameter metadata) {
        this.addField((AbstractParameter)metadata);
    }
}

