/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal.pathmatcher;

import io.takari.builder.internal.pathmatcher.PathNormalizer;
import java.io.StringWriter;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class PathMatcher {
    private static final char SEPARATOR_CHAR = '/';
    private static final String SEPARATOR = "/";
    private static final String EMPTY = "";
    private final Node root;

    private PathMatcher(Node root) {
        this.root = root;
    }

    public boolean includes(String path) throws IllegalArgumentException {
        return this.match((String)path, null).matchMode == MatchMode.include;
    }

    public String getMatchingRule(String path) throws IllegalArgumentException {
        ArrayList trail = new ArrayList();
        Node node = this.match(path, e -> {
            boolean bl = trail.add(e);
        });
        StringBuilder rule = new StringBuilder();
        rule.append(node.matchMode == MatchMode.include ? "+" : "-");
        for (Map.Entry entry : trail) {
            rule.append(SEPARATOR).append((String)entry.getKey());
            if (entry.getValue() == node) break;
        }
        if (node.children != null) {
            rule.append("/**");
        }
        return rule.toString();
    }

    private Node match(String path, Consumer<Map.Entry<String, Node>> trail) {
        Node rule = this.match0(path, trail);
        if (rule.matchMode == MatchMode.inherit) {
            throw new IllegalArgumentException("No rule matches path " + path);
        }
        return rule;
    }

    private Node match0(String path, Consumer<Map.Entry<String, Node>> trail) {
        if (path == null || path.isEmpty()) {
            throw new NullPointerException();
        }
        if (path.charAt(0) != '/') {
            throw new IllegalArgumentException("Path is not absolute " + path);
        }
        Node node = this.root;
        Node inherited = this.root;
        for (String element : PathMatcher.split(path)) {
            node = node.children.get(element);
            if (node == null) {
                return inherited;
            }
            if (trail != null) {
                trail.accept(new AbstractMap.SimpleImmutableEntry<String, Node>(element, node));
            }
            if (node.matchMode == MatchMode.inherit) continue;
            inherited = node;
        }
        node = node.children.get(EMPTY);
        return node != null ? node : inherited;
    }

    static Iterable<String> split(String path) {
        ArrayList<String> split = new ArrayList<String>();
        String[] stringArray = path.split(SEPARATOR);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (!element.isEmpty()) {
                if ("..".equals(element)) {
                    if (!split.isEmpty()) {
                        split.remove(split.size() - 1);
                    }
                } else if (!".".equals(element)) {
                    split.add(element);
                }
            }
            ++n2;
        }
        return split;
    }

    public void traverse(final RuleVisitor visitor) {
        this.traverse(new NodeVisitor(){
            final StringBuilder path = new StringBuilder();

            @Override
            public void enterPrefix(String name, Node node) {
                this.path.append(name).append(PathMatcher.SEPARATOR);
                if (node.matchMode != MatchMode.inherit) {
                    visitor.visit(node.matchMode == MatchMode.include, this.path.toString());
                }
            }

            @Override
            public void visitPath(String name, Node node) {
                if (!$assertionsDisabled && node.matchMode == MatchMode.inherit) {
                    throw new AssertionError();
                }
                visitor.visit(node.matchMode == MatchMode.include, String.valueOf(this.path.toString()) + name);
            }

            @Override
            public void leavePrefix(String name, Node node) {
                this.path.setLength(this.path.length() - name.length() - 1);
            }
        });
    }

    private void traverse(NodeVisitor visit) {
        this.traverse(visit, EMPTY, this.root);
    }

    private void traverse(NodeVisitor visitor, String name, Node node) {
        Node pathNode = node.children.get(EMPTY);
        if (pathNode != null) {
            visitor.visitPath(name, pathNode);
        }
        visitor.enterPrefix(name, node);
        node.children.forEach((childName, child) -> {
            if (!EMPTY.equals(childName)) {
                this.traverse(visitor, (String)childName, (Node)child);
            }
        });
        visitor.leavePrefix(name, node);
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        this.traverse((boolean includes, String path) -> {
            writer.write(includes ? "+" : "-");
            writer.write(path.toString());
            writer.write("\n");
        });
        return writer.toString();
    }

    public static Builder builder(PathNormalizer normalizer) {
        return new Builder(normalizer, MatchMode.inherit);
    }

    /* synthetic */ PathMatcher(Node node, PathMatcher pathMatcher) {
        this(node);
    }

    public static class Builder {
        private final PathNormalizer normalizer;
        private BuilderNode root;

        private Builder(PathNormalizer normalizer, MatchMode matchMode) {
            this.normalizer = normalizer;
            this.root = new BuilderNode();
            this.root.matchMode = matchMode;
        }

        BuilderNode getDirectoryNode(String path) {
            path = this.normalizer.normalize(path);
            BuilderNode node = this.root;
            for (String element : PathMatcher.split(path)) {
                node = this.getDirectoryNode(node, element);
            }
            return node;
        }

        BuilderNode getDirectoryNode(BuilderNode parent, String name) {
            BuilderNode child = parent.children.get(name);
            if (child == null) {
                child = new BuilderNode();
                parent.children.put(name, child);
            }
            return child;
        }

        public Builder addMatcher(PathMatcher matcher) {
            matcher.traverse(new NodeVisitor(){
                Deque<BuilderNode> stack = new ArrayDeque<BuilderNode>();

                @Override
                public void enterPrefix(String name, Node node) {
                    BuilderNode builderNode;
                    if (this.stack.isEmpty()) {
                        if (!$assertionsDisabled && !PathMatcher.EMPTY.equals(name)) {
                            throw new AssertionError();
                        }
                        builderNode = root;
                    } else {
                        builderNode = this.getDirectoryNode(this.stack.peek(), name);
                    }
                    if (node.matchMode != MatchMode.inherit) {
                        builderNode.matchMode = node.matchMode;
                    }
                    this.stack.push(builderNode);
                }

                @Override
                public void visitPath(String name, Node node) {
                    BuilderNode builderNode = new BuilderNode(node.matchMode);
                    this.getDirectoryNode((BuilderNode)this.stack.peek(), (String)name).children.put(PathMatcher.EMPTY, builderNode);
                }

                @Override
                public void leavePrefix(String name, Node node) {
                    this.stack.remove();
                }
            });
            return this;
        }

        public Builder includeRoot() {
            this.root.matchMode = MatchMode.include;
            return this;
        }

        public Builder excludeRoot() {
            this.root.matchMode = MatchMode.exclude;
            return this;
        }

        public Builder includePrefix(String path) {
            this.getDirectoryNode((String)path).matchMode = MatchMode.include;
            return this;
        }

        public Builder excludePrefix(String path) {
            this.getDirectoryNode((String)path).matchMode = MatchMode.exclude;
            return this;
        }

        public Builder includePath(String path) {
            this.getDirectoryNode((String)path).children.put(PathMatcher.EMPTY, new BuilderNode(MatchMode.include));
            return this;
        }

        public Builder excludePath(String path) {
            this.getDirectoryNode((String)path).children.put(PathMatcher.EMPTY, new BuilderNode(MatchMode.exclude));
            return this;
        }

        public PathMatcher build() {
            BuilderNode root = this.root;
            if (root == null) {
                root = new BuilderNode();
            }
            return new PathMatcher(root.toNode(), null);
        }
    }

    private static class BuilderNode {
        public final Map<String, BuilderNode> children;
        public MatchMode matchMode;

        public BuilderNode() {
            this.children = new HashMap<String, BuilderNode>();
            this.matchMode = MatchMode.inherit;
        }

        public BuilderNode(MatchMode matchMode) {
            this.children = null;
            this.matchMode = matchMode;
        }

        public Node toNode() {
            if (this.children == null) {
                return new Node(this.matchMode);
            }
            HashMap<String, Node> children = new HashMap<String, Node>();
            for (Map.Entry<String, BuilderNode> entry : this.children.entrySet()) {
                children.put(entry.getKey(), entry.getValue().toNode());
            }
            return new Node(children, this.matchMode);
        }
    }

    private static enum MatchMode {
        include,
        exclude,
        inherit;

    }

    private static class Node {
        public final Map<String, Node> children;
        public final MatchMode matchMode;

        public Node(Map<String, Node> children, MatchMode matchMode) {
            assert (children != null);
            this.children = children;
            this.matchMode = matchMode;
        }

        public Node(MatchMode matchMode) {
            assert (matchMode != MatchMode.inherit);
            this.children = null;
            this.matchMode = matchMode;
        }
    }

    private static interface NodeVisitor {
        public void enterPrefix(String var1, Node var2);

        public void visitPath(String var1, Node var2);

        public void leavePrefix(String var1, Node var2);
    }

    public static interface RuleVisitor {
        public void visit(boolean var1, String var2);
    }
}

